/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption.metadata.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.nifi.repository.encryption.configuration.EncryptionProtocol;
import org.apache.nifi.repository.encryption.configuration.RepositoryEncryptionMethod;
import org.apache.nifi.repository.encryption.metadata.RecordMetadataSerializer;
import org.apache.nifi.repository.encryption.metadata.serialization.StandardRecordMetadata;

public class StandardRecordMetadataSerializer
implements RecordMetadataSerializer {
    private final EncryptionProtocol encryptionProtocol;

    public StandardRecordMetadataSerializer(EncryptionProtocol encryptionProtocol) {
        this.encryptionProtocol = Objects.requireNonNull(encryptionProtocol, "Encryption Protocol required");
    }

    @Override
    public byte[] writeMetadata(String keyId, byte[] initializationVector, int length, RepositoryEncryptionMethod repositoryEncryptionMethod) {
        Objects.requireNonNull(keyId, "Key Identifier required");
        Objects.requireNonNull(repositoryEncryptionMethod, "Repository Encryption Method required");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            StandardRecordMetadata recordMetadata = new StandardRecordMetadata();
            recordMetadata.keyId = keyId;
            recordMetadata.ivBytes = initializationVector;
            recordMetadata.cipherByteLength = length;
            recordMetadata.algorithm = repositoryEncryptionMethod.getAlgorithm();
            recordMetadata.version = this.encryptionProtocol.getVersion();
            objectOutputStream.writeObject(recordMetadata);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Write Metadata Key ID [%s] Failed", keyId), e);
        }
        return outputStream.toByteArray();
    }
}

