/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import org.apache.nifi.controller.leader.election.CuratorLeaderElectionManager;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.StandaloneLeaderElectionManager;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.factory.FactoryBean;

public class LeaderElectionManagerFactoryBean
implements FactoryBean<LeaderElectionManager> {
    private int numThreads;
    private NiFiProperties properties;

    public LeaderElectionManager getObject() throws Exception {
        boolean isNode = this.properties.isNode();
        if (isNode) {
            return new CuratorLeaderElectionManager(this.numThreads, this.properties);
        }
        return new StandaloneLeaderElectionManager();
    }

    public Class<?> getObjectType() {
        return LeaderElectionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

