/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.backup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupBean
implements Backupable {
    private static final Logger logger = LoggerFactory.getLogger(BackupBean.class);
    private final Backupable[] targets;
    private volatile long backupStartTicks;
    private String backupPath;
    private boolean backupToZip;
    private String backupNamePrefix;
    private String commandAfterBackup;
    private final List<Runnable> runAfterBackup = new ArrayList<Runnable>();
    private Throwable backupException;

    public BackupBean(Backupable target) {
        this.targets = new Backupable[]{target};
    }

    public BackupBean(List<Backupable> targets) {
        int targetsCount = targets.size();
        if (targetsCount < 1) {
            throw new IllegalArgumentException();
        }
        this.targets = targets.toArray(new Backupable[targetsCount]);
    }

    public void setBackupPath(@NotNull String backupPath) {
        this.backupPath = backupPath;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public boolean getBackupToZip() {
        return this.backupToZip;
    }

    public void setBackupToZip(boolean zip) {
        this.backupToZip = zip;
    }

    public String getBackupNamePrefix() {
        return this.backupNamePrefix;
    }

    public void setBackupNamePrefix(String prefix) {
        this.backupNamePrefix = prefix;
    }

    public void setCommandAfterBackup(@Nullable String command) {
        this.commandAfterBackup = command;
    }

    public String getCommandAfterBackup() {
        return this.commandAfterBackup;
    }

    public void executeAfterBackup(@NotNull Runnable runnable) {
        this.runAfterBackup.add(runnable);
    }

    public void setBackupStartTicks(long backupStartTicks) {
        this.backupStartTicks = backupStartTicks;
    }

    public long getBackupStartTicks() {
        return this.backupStartTicks;
    }

    public boolean isBackupInProgress() {
        return this.backupStartTicks > 0L;
    }

    public void setBackupException(Throwable backupException) {
        this.backupException = backupException;
    }

    public Throwable getBackupException() {
        return this.backupException;
    }

    @Override
    @NotNull
    public BackupStrategy getBackupStrategy() {
        final int targetsCount = this.targets.length;
        final BackupStrategy[] wrapped = new BackupStrategy[targetsCount];
        for (int i = 0; i < targetsCount; ++i) {
            wrapped[i] = this.targets[i].getBackupStrategy();
        }
        return new BackupStrategy(){

            @Override
            public void beforeBackup() throws Exception {
                BackupBean.this.backupStartTicks = System.currentTimeMillis();
                logger.info("Backing up database...");
                for (BackupStrategy strategy : wrapped) {
                    strategy.beforeBackup();
                }
            }

            @Override
            public Iterable<VirtualFileDescriptor> getContents() {
                return new Iterable<VirtualFileDescriptor>(){

                    @Override
                    @NotNull
                    public Iterator<VirtualFileDescriptor> iterator() {
                        return new Iterator<VirtualFileDescriptor>(){
                            @Nullable
                            private VirtualFileDescriptor next = null;
                            private int i = 0;
                            @NotNull
                            private Iterator<VirtualFileDescriptor> it = BackupStrategy.EMPTY.getContents().iterator();

                            @Override
                            public boolean hasNext() {
                                return this.getNext() != null;
                            }

                            @Override
                            public VirtualFileDescriptor next() {
                                try {
                                    VirtualFileDescriptor virtualFileDescriptor = this.getNext();
                                    return virtualFileDescriptor;
                                }
                                finally {
                                    this.next = null;
                                }
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("remove");
                            }

                            private VirtualFileDescriptor getNext() {
                                if (this.next == null) {
                                    while (!this.it.hasNext()) {
                                        if (this.i >= targetsCount) {
                                            return this.next;
                                        }
                                        this.it = wrapped[this.i++].getContents().iterator();
                                    }
                                    VirtualFileDescriptor next = this.it.next();
                                    long acceptedSize = wrapped[this.i - 1].acceptFile(next);
                                    this.next = acceptedSize < next.getFileSize() ? next.copy(acceptedSize) : next;
                                }
                                return this.next;
                            }
                        };
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void afterBackup() throws Exception {
                try {
                    for (BackupStrategy strategy : wrapped) {
                        strategy.afterBackup();
                    }
                }
                finally {
                    BackupBean.this.backupStartTicks = 0L;
                }
                for (Runnable runnable : BackupBean.this.runAfterBackup) {
                    runnable.run();
                }
                if (BackupBean.this.commandAfterBackup != null) {
                    logger.info("Executing \"" + BackupBean.this.commandAfterBackup + "\"...");
                    Runtime.getRuntime().exec(BackupBean.this.commandAfterBackup);
                }
                logger.info("Backup finished.");
            }

            @Override
            public void onError(Throwable t) {
                BackupBean.this.backupException = t;
            }
        };
    }
}

