/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.LongSupplier;

public class LimitedInputStream
extends InputStream {
    private final InputStream in;
    private final long limit;
    private final LongSupplier limitSupplier;
    private long bytesRead = 0L;
    private long markOffset = -1L;

    public LimitedInputStream(InputStream in, LongSupplier limitSupplier) {
        this.in = in;
        this.limitSupplier = Objects.requireNonNull(limitSupplier);
        this.limit = -1L;
    }

    public LimitedInputStream(InputStream in, long limit) {
        this.in = in;
        this.limit = limit;
        this.limitSupplier = null;
    }

    private long getLimit() {
        return this.limitSupplier == null ? this.limit : this.limitSupplier.getAsLong();
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.getLimit()) {
            return -1;
        }
        int val = this.in.read();
        if (val > -1) {
            ++this.bytesRead;
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        long limit = this.getLimit();
        if (this.bytesRead >= limit) {
            return -1;
        }
        int maxToRead = (int)Math.min((long)b.length, limit - this.bytesRead);
        int val = this.in.read(b, 0, maxToRead);
        if (val > 0) {
            this.bytesRead += (long)val;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long limit = this.getLimit();
        if (this.bytesRead >= limit) {
            return -1;
        }
        int maxToRead = (int)Math.min((long)len, limit - this.bytesRead);
        int val = this.in.read(b, off, maxToRead);
        if (val > 0) {
            this.bytesRead += (long)val;
        }
        return val;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(Math.min(n, this.getLimit() - this.bytesRead));
        this.bytesRead += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.getLimit() - this.bytesRead);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markOffset = this.bytesRead;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        if (this.markOffset >= 0L) {
            this.bytesRead = this.markOffset;
        }
        this.markOffset = -1L;
    }
}

