/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.log.Log;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import io.questdb.tasks.ColumnPurgeTask;

public abstract class PurgingOperator {
    protected final LongList cleanupColumnVersions = new LongList();
    protected final CairoConfiguration configuration;
    protected final FilesFacade ff;
    protected final MessageBus messageBus;
    protected final Path path;
    protected final int rootLen;
    protected final TableWriter tableWriter;
    protected final IntList updateColumnIndexes = new IntList();
    private final LongList cleanupColumnVersionsAsync = new LongList();
    private final Log log;

    protected PurgingOperator(Log log, CairoConfiguration configuration, MessageBus messageBus, TableWriter tableWriter, Path path, int rootLen) {
        this.log = log;
        this.configuration = configuration;
        this.messageBus = messageBus;
        this.ff = configuration.getFilesFacade();
        this.tableWriter = tableWriter;
        this.path = path;
        this.rootLen = rootLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeOldColumnVersions() {
        boolean anyReadersBeforeCommittedTxn = this.tableWriter.checkScoreboardHasReadersBeforeLastCommittedTxn();
        TableRecordMetadata tableMetadata = this.tableWriter.getMetadata();
        this.path.trimTo(this.rootLen);
        long updateTxn = this.tableWriter.getTxn();
        try {
            int nn = this.updateColumnIndexes.size();
            for (int updatedCol = 0; updatedCol < nn; ++updatedCol) {
                int processColumnIndex = this.updateColumnIndexes.getQuick(updatedCol);
                String columnName = tableMetadata.getColumnName(processColumnIndex);
                int columnType = tableMetadata.getColumnType(processColumnIndex);
                this.cleanupColumnVersionsAsync.clear();
                int n = this.cleanupColumnVersions.size();
                for (int i = 0; i < n; i += 4) {
                    boolean columnPurged;
                    int columnIndex = (int)this.cleanupColumnVersions.getQuick(i);
                    long columnVersion = this.cleanupColumnVersions.getQuick(i + 1);
                    long partitionTimestamp = this.cleanupColumnVersions.getQuick(i + 2);
                    long partitionNameTxn = this.cleanupColumnVersions.getQuick(i + 3);
                    if (columnIndex != processColumnIndex) continue;
                    boolean bl = columnPurged = !anyReadersBeforeCommittedTxn;
                    if (!anyReadersBeforeCommittedTxn) {
                        this.path.trimTo(this.rootLen);
                        TableUtils.setPathForPartition(this.path, this.tableWriter.getPartitionBy(), partitionTimestamp, false);
                        TableUtils.txnPartitionConditionally(this.path, partitionNameTxn);
                        int pathPartitionLen = this.path.length();
                        TableUtils.dFile(this.path, columnName, columnVersion);
                        if (!this.ff.remove(this.path.$())) {
                            columnPurged = false;
                        }
                        if (columnPurged && ColumnType.isVariableLength(columnType)) {
                            this.path.trimTo(pathPartitionLen);
                            TableUtils.iFile(this.path, columnName, columnVersion);
                            TableUtils.iFile(this.path.$(), columnName, columnVersion);
                            if (!this.ff.remove(this.path.$()) && this.ff.exists(this.path)) {
                                columnPurged = false;
                            }
                        }
                        if (columnPurged && tableMetadata.isColumnIndexed(columnIndex)) {
                            this.path.trimTo(pathPartitionLen);
                            BitmapIndexUtils.valueFileName(this.path, columnName, columnVersion);
                            if (!this.ff.remove(this.path.$()) && this.ff.exists(this.path)) {
                                columnPurged = false;
                            }
                            this.path.trimTo(pathPartitionLen);
                            BitmapIndexUtils.keyFileName(this.path, columnName, columnVersion);
                            if (!this.ff.remove(this.path.$()) && this.ff.exists(this.path)) {
                                columnPurged = false;
                            }
                        }
                    }
                    if (columnPurged) continue;
                    this.cleanupColumnVersionsAsync.add(columnVersion, partitionTimestamp, partitionNameTxn, 0L);
                }
                if (this.cleanupColumnVersionsAsync.size() > 0) {
                    this.purgeColumnVersionAsync(this.tableWriter.getTableToken(), columnName, tableMetadata.getTableId(), (int)this.tableWriter.getTruncateVersion(), columnType, this.tableWriter.getPartitionBy(), updateTxn, this.cleanupColumnVersionsAsync);
                    this.log.info().$("column purge scheduled [table=").utf8(this.tableWriter.getTableToken().getTableName()).$(", column=").utf8(columnName).$(", updateTxn=").$(updateTxn).I$();
                    continue;
                }
                this.log.info().$("columns purged locally [table=").utf8(this.tableWriter.getTableToken().getTableName()).$(", column=").utf8(columnName).$(", newColumnVersion=").$(updateTxn - 1L).I$();
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void purgeColumnVersionAsync(TableToken tableName, CharSequence columnName, int tableId, int tableTruncateVersion, int columnType, int partitionBy, long updateTxn, LongList columnVersions) {
        Sequence pubSeq = this.messageBus.getColumnPurgePubSeq();
        while (true) {
            long cursor;
            if ((cursor = pubSeq.next()) > -1L) {
                ColumnPurgeTask task = this.messageBus.getColumnPurgeQueue().get(cursor);
                task.of(tableName, columnName, tableId, tableTruncateVersion, columnType, partitionBy, updateTxn, columnVersions);
                pubSeq.done(cursor);
                return;
            }
            if (cursor == -1L) {
                this.log.error().$("cannot schedule column purge, purge queue is full. Please run 'VACUUM TABLE \"").utf8(tableName.getTableName()).$("\"' [columnName=").utf8(columnName).$(", updateTxn=").$(updateTxn).I$();
                return;
            }
            Os.pause();
        }
    }
}

