/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToLongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastDoubleToLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Dl)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToLongFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public long getLong(Record rec) {
            double value = this.arg.getDouble(rec);
            return Double.isNaN(value) ? Long.MIN_VALUE : (long)value;
        }
    }
}

