/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class AvgDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public AvgDoubleGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        double d = this.arg.getDouble(record);
        if (Numbers.isFinite(d)) {
            mapValue.putDouble(this.valueIndex, d);
            mapValue.putLong(this.valueIndex + 1, 1L);
        } else {
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putLong(this.valueIndex + 1, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        double d = this.arg.getDouble(record);
        if (Numbers.isFinite(d)) {
            mapValue.addDouble(this.valueIndex, d);
            mapValue.addLong(this.valueIndex + 1, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getDouble(this.valueIndex) / (double)rec.getLong(this.valueIndex + 1);
    }

    @Override
    public String getName() {
        return "avg";
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(6);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 1, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }
}

