/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class BitwiseNotIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "~(I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new BitNotIntFunction(args.getQuick(0));
    }

    public static final class BitNotIntFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function value;

        public BitNotIntFunction(Function value) {
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public int getInt(Record rec) {
            int val = this.value.getInt(rec);
            return val != Integer.MIN_VALUE ? ~val : Integer.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('~').val(this.value);
        }
    }
}

