/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client.socket;

import java.net.Socket;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.nifi.remote.client.socket.SocketPeerIdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSocketPeerIdentityProvider
implements SocketPeerIdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardSocketPeerIdentityProvider.class);

    @Override
    public Optional<String> getPeerIdentity(Socket socket) {
        Optional<String> peerIdentity;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = sslSocket.getSession();
            peerIdentity = this.getPeerIdentity(sslSession);
        } else {
            peerIdentity = Optional.empty();
        }
        return peerIdentity;
    }

    private Optional<String> getPeerIdentity(SSLSession sslSession) {
        String peerIdentity = null;
        String peerHost = sslSession.getPeerHost();
        int peerPort = sslSession.getPeerPort();
        try {
            Certificate[] peerCertificates = sslSession.getPeerCertificates();
            if (peerCertificates == null || peerCertificates.length == 0) {
                logger.warn("Peer Identity not found: Peer Certificates not provided [{}:{}]", (Object)peerHost, (Object)peerPort);
            } else {
                X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
                Principal subjectDistinguishedName = peerCertificate.getSubjectDN();
                peerIdentity = subjectDistinguishedName.getName();
            }
        }
        catch (SSLPeerUnverifiedException e) {
            logger.warn("Peer Identity not found: Peer Unverified [{}:{}]", (Object)peerHost, (Object)peerPort);
            logger.debug("TLS Protocol [{}] Peer Unverified [{}:{}]", new Object[]{sslSession.getProtocol(), peerHost, peerPort, e});
        }
        return Optional.ofNullable(peerIdentity);
    }
}

