/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionFactoryDescriptor;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.bind.NamedParameterLinkFunction;
import io.questdb.griffin.engine.functions.cast.AbstractCastToTimestampFunction;
import io.questdb.griffin.engine.functions.cast.CastGeoHashToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToUuidFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastSymbolToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastUuidToStrFunctionFactory;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.GeoByteColumn;
import io.questdb.griffin.engine.functions.columns.GeoIntColumn;
import io.questdb.griffin.engine.functions.columns.GeoLongColumn;
import io.questdb.griffin.engine.functions.columns.GeoShortColumn;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.Long128Column;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.RecordColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.SymbolColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.columns.UuidColumn;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.griffin.engine.functions.constants.DateConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.GeoByteConstant;
import io.questdb.griffin.engine.functions.constants.GeoHashTypeConstant;
import io.questdb.griffin.engine.functions.constants.GeoIntConstant;
import io.questdb.griffin.engine.functions.constants.GeoLongConstant;
import io.questdb.griffin.engine.functions.constants.GeoShortConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.Long256Constant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.functions.constants.UuidConstant;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.IntStack;
import io.questdb.std.Long256Impl;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import java.io.Closeable;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionParser
implements PostOrderTreeTraversalAlgo.Visitor,
Mutable {
    private static final Log LOG = LogFactory.getLog(FunctionParser.class);
    private static final int MATCH_EXACT_MATCH = 3;
    private static final int MATCH_FUZZY_MATCH = 1;
    private static final int MATCH_NO_MATCH = 0;
    private static final int MATCH_PARTIAL_MATCH = 2;
    private final CairoConfiguration configuration;
    private final FunctionFactoryCache functionFactoryCache;
    private final ArrayDeque<Function> functionStack = new ArrayDeque();
    private final Long256Impl long256Sink = new Long256Impl();
    private final ArrayDeque<RecordMetadata> metadataStack = new ArrayDeque();
    private final IntList mutableArgPositions = new IntList();
    private final ObjList<Function> mutableArgs = new ObjList();
    private final IntStack positionStack = new IntStack();
    private final PostOrderTreeTraversalAlgo traverseAlgo = new PostOrderTreeTraversalAlgo();
    private final IntList undefinedVariables = new IntList();
    private RecordMetadata metadata;
    private SqlCodeGenerator sqlCodeGenerator;
    private SqlExecutionContext sqlExecutionContext;

    public FunctionParser(CairoConfiguration configuration, FunctionFactoryCache functionFactoryCache) {
        this.configuration = configuration;
        this.functionFactoryCache = functionFactoryCache;
    }

    @NotNull
    public static ScalarFunction createColumn(int position, CharSequence name, RecordMetadata metadata) throws SqlException {
        int index = metadata.getColumnIndexQuiet(name);
        if (index == -1) {
            throw SqlException.invalidColumn(position, name);
        }
        int columnType = metadata.getColumnType(index);
        switch (ColumnType.tagOf(columnType)) {
            case 1: {
                return BooleanColumn.newInstance(index);
            }
            case 2: {
                return ByteColumn.newInstance(index);
            }
            case 3: {
                return ShortColumn.newInstance(index);
            }
            case 4: {
                return CharColumn.newInstance(index);
            }
            case 5: {
                return IntColumn.newInstance(index);
            }
            case 6: {
                return LongColumn.newInstance(index);
            }
            case 9: {
                return FloatColumn.newInstance(index);
            }
            case 10: {
                return DoubleColumn.newInstance(index);
            }
            case 11: {
                return StrColumn.newInstance(index);
            }
            case 12: {
                return new SymbolColumn(index, metadata.isSymbolTableStatic(index));
            }
            case 18: {
                return BinColumn.newInstance(index);
            }
            case 7: {
                return DateColumn.newInstance(index);
            }
            case 8: {
                return TimestampColumn.newInstance(index);
            }
            case 22: {
                return new RecordColumn(index, metadata.getMetadata(index));
            }
            case 14: {
                return GeoByteColumn.newInstance(index, columnType);
            }
            case 15: {
                return GeoShortColumn.newInstance(index, columnType);
            }
            case 16: {
                return GeoIntColumn.newInstance(index, columnType);
            }
            case 17: {
                return GeoLongColumn.newInstance(index, columnType);
            }
            case 29: {
                return NullConstant.NULL;
            }
            case 13: {
                return Long256Column.newInstance(index);
            }
            case 24: {
                return Long128Column.newInstance(index);
            }
            case 19: {
                return UuidColumn.newInstance(index);
            }
        }
        throw SqlException.position(position).put("unsupported column type ").put(ColumnType.nameOf(columnType));
    }

    @Override
    public void clear() {
        this.sqlExecutionContext = null;
    }

    public Function createBindVariable(SqlExecutionContext sqlExecutionContext, int position, CharSequence name, int expressionType) throws SqlException {
        this.sqlExecutionContext = sqlExecutionContext;
        if (name != null) {
            if (name.length() > 0) {
                if (expressionType != 6) {
                    return new StrConstant(name);
                }
                switch (name.charAt(0)) {
                    case ':': {
                        return this.createNamedParameter(position, name);
                    }
                    case '$': {
                        return this.parseIndexedParameter(position, name);
                    }
                }
                return new StrConstant(name);
            }
            return StrConstant.EMPTY;
        }
        return NullConstant.NULL;
    }

    public Function createImplicitCast(int position, Function function, int toType) throws SqlException {
        Function cast = this.createImplicitCastOrNull(position, function, toType);
        if (cast != null && cast.isConstant()) {
            Function constant = this.functionToConstant(cast);
            function.close();
            return constant;
        }
        return cast;
    }

    public boolean findNoArgFunction(ExpressionNode node) {
        ObjList<FunctionFactoryDescriptor> overload = this.functionFactoryCache.getOverloadList(node.token);
        if (overload != null) {
            int n = overload.size();
            for (int i = 0; i < n; ++i) {
                if (overload.getQuick(i).getSigArgCount() != 0) continue;
                return true;
            }
        }
        return false;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionFactoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function parseFunction(ExpressionNode node, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        this.sqlExecutionContext = executionContext;
        if (this.metadata != null) {
            this.metadataStack.push(this.metadata);
        }
        try {
            this.metadata = metadata;
            try {
                this.traverseAlgo.traverse(node, this);
            }
            catch (Exception e) {
                for (int i = this.functionStack.size(); i > 0; --i) {
                    Misc.free((Closeable)this.functionStack.poll());
                }
                this.positionStack.clear();
                throw e;
            }
            Function function = this.functionStack.poll();
            this.positionStack.pop();
            assert (this.positionStack.size() == this.functionStack.size());
            if (function != null && function.isConstant() && function instanceof ScalarFunction) {
                Function function2 = this.functionToConstant(function);
                return function2;
            }
            Function function3 = function;
            return function3;
        }
        finally {
            this.metadata = this.metadataStack.size() == 0 ? null : this.metadataStack.poll();
        }
    }

    public void setSqlCodeGenerator(SqlCodeGenerator sqlCodeGenerator) {
        this.sqlCodeGenerator = sqlCodeGenerator;
    }

    @Override
    public void visit(ExpressionNode node) throws SqlException {
        int argCount = node.paramCount;
        if (argCount == 0) {
            switch (node.type) {
                case 4: {
                    this.functionStack.push(this.createColumn(node.position, node.token));
                    break;
                }
                case 6: {
                    this.functionStack.push(this.createBindVariable0(node.position, node.token));
                    break;
                }
                case 5: {
                    this.functionStack.push(new StrConstant(node.token));
                    break;
                }
                case 2: {
                    this.functionStack.push(this.createConstant(node.position, node.token));
                    break;
                }
                case 65: {
                    this.functionStack.push(this.createCursorFunction(node));
                    break;
                }
                default: {
                    this.functionStack.push(this.createFunction(node, null, null));
                    break;
                }
            }
        } else {
            this.mutableArgs.clear();
            this.mutableArgs.setPos(argCount);
            this.mutableArgPositions.clear();
            this.mutableArgPositions.setPos(argCount);
            for (int n = 0; n < argCount; ++n) {
                Function arg = this.functionStack.poll();
                int pos = this.positionStack.pop();
                this.mutableArgs.setQuick(n, arg);
                this.mutableArgPositions.setQuick(n, pos);
                if (!(arg instanceof GroupByFunction)) continue;
                Misc.freeObjList(this.mutableArgs);
                throw SqlException.position(pos).put("Aggregate function cannot be passed as an argument");
            }
            this.functionStack.push(this.createFunction(node, this.mutableArgs, this.mutableArgPositions));
        }
        this.positionStack.push(node.position);
    }

    private static SqlException invalidArgument(ExpressionNode node, ObjList<Function> args, FunctionFactoryDescriptor descriptor) {
        int i;
        int n;
        SqlException ex = SqlException.position(node.position);
        ex.put("unexpected argument for function: ");
        ex.put(node.token);
        ex.put(". expected args: ");
        ex.put('(');
        if (descriptor != null) {
            n = descriptor.getSigArgCount();
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                int mask = descriptor.getArgTypeMask(i);
                ex.put(ColumnType.nameOf(FunctionFactoryDescriptor.toType(mask)));
                if (FunctionFactoryDescriptor.isArray(mask)) {
                    ex.put("[]");
                }
                if (!FunctionFactoryDescriptor.isConstant(mask)) continue;
                ex.put(" constant");
            }
        }
        ex.put("). actual args: ");
        ex.put('(');
        if (args != null) {
            n = args.size();
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                Function arg = args.getQuick(i);
                ex.put(ColumnType.nameOf(arg.getType()));
                if (!arg.isConstant()) continue;
                ex.put(" constant");
            }
        }
        ex.put(')');
        Misc.freeObjList(args);
        return ex;
    }

    private static SqlException invalidFunction(ExpressionNode node, ObjList<Function> args) {
        SqlException ex = SqlException.position(node.position);
        ex.put("unknown function name");
        ex.put(": ");
        ex.put(node.token);
        ex.put('(');
        if (args != null) {
            int n = args.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                ex.put(ColumnType.nameOf(args.getQuick(i).getType()));
            }
        }
        ex.put(')');
        Misc.freeObjList(args);
        return ex;
    }

    private Function checkAndCreateFunction(FunctionFactory factory, ObjList<Function> args, IntList argPositions, ExpressionNode node, CairoConfiguration configuration) throws SqlException {
        Function function;
        int position = node.position;
        try {
            LOG.debug().$("call ").$(node).$(" -> ").$(factory.getSignature()).$();
            function = factory.newInstance(position, args, argPositions, configuration, this.sqlExecutionContext);
        }
        catch (ImplicitCastException | SqlException e) {
            Misc.freeObjList(args);
            throw e;
        }
        catch (Throwable e) {
            LOG.error().$("exception in function factory: ").$(e).$();
            Misc.freeObjList(args);
            throw SqlException.position(position).put("exception in function factory");
        }
        if (function == null) {
            LOG.error().$("NULL function").$(" [signature=").$(factory.getSignature()).$(",class=").$(factory.getClass().getName()).$(']').$();
            Misc.freeObjList(args);
            throw SqlException.position(position).put("bad function factory (NULL), check log");
        }
        return function;
    }

    private long convertToTimestamp(CharSequence str, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialTimestamp(str);
        }
        catch (NumericException e) {
            throw SqlException.invalidDate(position);
        }
    }

    private Function createBindVariable0(int position, CharSequence name) throws SqlException {
        if (name.charAt(0) != ':') {
            return this.parseIndexedParameter(position, name);
        }
        return this.createNamedParameter(position, name);
    }

    private Function createColumn(int position, CharSequence columnName) throws SqlException {
        return FunctionParser.createColumn(position, columnName, this.metadata);
    }

    private Function createConstant(int position, CharSequence tok) throws SqlException {
        int len = tok.length();
        if (SqlKeywords.isNullKeyword(tok)) {
            return NullConstant.NULL;
        }
        if (Chars.isQuoted(tok)) {
            if (len == 3) {
                return CharConstant.newInstance(tok.charAt(1));
            }
            if (len == 2) {
                return StrConstant.EMPTY;
            }
            return new StrConstant(tok);
        }
        if (len > 2 && tok.charAt(0) == 'E' && tok.charAt(1) == '\'') {
            return new StrConstant(Chars.toString(tok, 2, len - 1));
        }
        if (SqlKeywords.isTrueKeyword(tok)) {
            return BooleanConstant.TRUE;
        }
        if (SqlKeywords.isFalseKeyword(tok)) {
            return BooleanConstant.FALSE;
        }
        try {
            return IntConstant.newInstance(Numbers.parseInt(tok));
        }
        catch (NumericException numericException) {
            try {
                return LongConstant.newInstance(Numbers.parseLong(tok));
            }
            catch (NumericException numericException2) {
                try {
                    return DoubleConstant.newInstance(Numbers.parseDouble(tok));
                }
                catch (NumericException numericException3) {
                    try {
                        return FloatConstant.newInstance(Numbers.parseFloat(tok));
                    }
                    catch (NumericException numericException4) {
                        ConstantFunction geoConstant;
                        short columnType = ColumnType.tagOf(tok);
                        if (columnType >= 1 && columnType <= 18 || columnType == 25 || columnType == 26 || columnType == 27 || columnType == 19) {
                            return Constants.getTypeConstant(columnType);
                        }
                        if (SqlKeywords.startsWithGeoHashKeyword(tok)) {
                            return GeoHashTypeConstant.getInstanceByPrecision(GeoHashUtil.parseGeoHashBits(position, 7, tok));
                        }
                        if (len > 1 && tok.charAt(0) == '#' && (geoConstant = GeoHashUtil.parseGeoHashConstant(position, tok, len)) != null) {
                            return geoConstant;
                        }
                        if (Numbers.extractLong256(tok, len, this.long256Sink)) {
                            return new Long256Constant(this.long256Sink);
                        }
                        throw SqlException.position(position).put("invalid constant: ").put(tok);
                    }
                }
            }
        }
    }

    private Function createCursorFunction(ExpressionNode node) throws SqlException {
        assert (node.queryModel != null);
        this.sqlExecutionContext.pushTimestampRequiredFlag(false);
        try {
            CursorFunction cursorFunction = new CursorFunction(this.sqlCodeGenerator.generate(node.queryModel, this.sqlExecutionContext));
            return cursorFunction;
        }
        finally {
            this.sqlExecutionContext.popTimestampRequiredFlag();
        }
    }

    private Function createFunction(ExpressionNode node, ObjList<Function> args, IntList argPositions) throws SqlException {
        int k;
        int i;
        ObjList<FunctionFactoryDescriptor> overload = this.functionFactoryCache.getOverloadList(node.token);
        if (overload == null) {
            throw FunctionParser.invalidFunction(node, args);
        }
        int argCount = args == null ? 0 : args.size();
        FunctionFactory candidate = null;
        FunctionFactoryDescriptor candidateDescriptor = null;
        boolean candidateSigVarArgConst = false;
        int candidateSigArgCount = 0;
        int candidateSigArgTypeSum = -1;
        int bestMatch = 0;
        this.undefinedVariables.clear();
        for (i = 0; i < argCount; ++i) {
            if (!args.getQuick(i).isUndefined()) continue;
            this.undefinedVariables.add(i);
        }
        int n = overload.size();
        for (i = 0; i < n; ++i) {
            boolean sigVarArgConst;
            boolean sigVarArg;
            FunctionFactoryDescriptor descriptor = overload.getQuick(i);
            FunctionFactory factory = descriptor.getFactory();
            int sigArgCount = descriptor.getSigArgCount();
            if (sigArgCount > 0) {
                int lastSigArgMask = descriptor.getArgTypeMask(sigArgCount - 1);
                sigVarArg = FunctionFactoryDescriptor.toType(lastSigArgMask) == 21;
                sigVarArgConst = FunctionFactoryDescriptor.isConstant(lastSigArgMask);
            } else {
                sigVarArg = false;
                sigVarArgConst = false;
            }
            if (sigVarArg) {
                --sigArgCount;
            }
            if (argCount == 0 && sigArgCount == 0) {
                return this.checkAndCreateFunction(factory, args, argPositions, node, this.configuration);
            }
            if (candidateDescriptor == null) {
                candidateDescriptor = descriptor;
            }
            if (sigArgCount != argCount && (!sigVarArg || argCount < sigArgCount)) continue;
            int match = 0;
            if (sigArgCount == 0) {
                match = 3;
            }
            int sigArgTypeSum = 0;
            for (int k2 = 0; k2 < sigArgCount; ++k2) {
                Function arg = args.getQuick(k2);
                int sigArgTypeMask = descriptor.getArgTypeMask(k2);
                if (FunctionFactoryDescriptor.isConstant(sigArgTypeMask) && !arg.isConstant()) {
                    match = 0;
                    break;
                }
                boolean isArray = FunctionFactoryDescriptor.isArray(sigArgTypeMask);
                boolean isScalar = arg instanceof ScalarFunction;
                if (isArray && isScalar || !isArray && !isScalar) {
                    match = 0;
                    break;
                }
                short sigArgType = FunctionFactoryDescriptor.toType(sigArgTypeMask);
                int argType = arg.getType();
                short argTypeTag = ColumnType.tagOf(argType);
                short sigArgTypeTag = ColumnType.tagOf(sigArgType);
                if (sigArgTypeTag == argTypeTag || sigArgTypeTag == 23 && ColumnType.isGeoHash(argType)) {
                    switch (match) {
                        case 0: {
                            match = 3;
                            break;
                        }
                        case 1: {
                            match = 2;
                            break;
                        }
                    }
                    continue;
                }
                boolean overloadPossible = false;
                if (k2 != 1 || !Chars.equals((CharSequence)"cast", node.token)) {
                    int overloadDistance = ColumnType.overloadDistance(argTypeTag, sigArgType);
                    sigArgTypeSum += overloadDistance;
                    overloadPossible = overloadDistance != 10000;
                    overloadPossible |= argTypeTag == 10 && arg.isConstant() && Double.isNaN(arg.getDouble(null)) && (sigArgTypeTag == 6 || sigArgTypeTag == 5);
                    overloadPossible |= argTypeTag == 4 && sigArgTypeTag == 11;
                    overloadPossible |= argTypeTag == 11 && arg.isConstant() && sigArgTypeTag == 8 && !factory.isGroupBy();
                    overloadPossible |= argTypeTag == 11 && sigArgTypeTag == 23 && !factory.isGroupBy();
                    overloadPossible |= argTypeTag == 12 && arg.isConstant() && sigArgTypeTag == 8 && !factory.isGroupBy();
                    overloadPossible |= arg.isUndefined();
                }
                if (overloadPossible) {
                    switch (match) {
                        case 0: {
                            if (argTypeTag == 29) {
                                match = 2;
                                break;
                            }
                            match = 1;
                            break;
                        }
                        case 3: {
                            match = 2;
                            break;
                        }
                    }
                    continue;
                }
                match = 0;
                break;
            }
            if (match == 0 || match != 3 && match < bestMatch) continue;
            if (match != 3) {
                if (candidateSigArgTypeSum > sigArgTypeSum || bestMatch < match) {
                    candidate = factory;
                    candidateDescriptor = descriptor;
                    candidateSigArgCount = sigArgCount;
                    candidateSigVarArgConst = sigVarArgConst;
                    candidateSigArgTypeSum = sigArgTypeSum;
                }
                bestMatch = match;
                continue;
            }
            candidate = factory;
            candidateDescriptor = descriptor;
            candidateSigArgCount = sigArgCount;
            candidateSigVarArgConst = sigVarArgConst;
            break;
        }
        if (candidate == null) {
            throw FunctionParser.invalidArgument(node, args, candidateDescriptor);
        }
        if (candidateSigVarArgConst) {
            for (k = candidateSigArgCount; k < argCount; ++k) {
                Function func = args.getQuick(k);
                if (func.isConstant() || func.isRuntimeConstant()) continue;
                Misc.freeObjList(args);
                throw SqlException.$(argPositions.getQuick(k), "constant expected");
            }
        }
        n = this.undefinedVariables.size();
        for (i = 0; i < n; ++i) {
            int pos = this.undefinedVariables.getQuick(i);
            if (pos < candidateSigArgCount) {
                short sigArgType = FunctionFactoryDescriptor.toType(candidateDescriptor.getArgTypeMask(pos));
                args.getQuick(pos).assignType(sigArgType, this.sqlExecutionContext.getBindVariableService());
                continue;
            }
            args.getQuick(pos).assignType(21, this.sqlExecutionContext.getBindVariableService());
        }
        for (k = 0; k < candidateSigArgCount; ++k) {
            Function arg = args.getQuick(k);
            short sigArgTypeTag = FunctionFactoryDescriptor.toType(candidateDescriptor.getArgTypeMask(k));
            short argTypeTag = ColumnType.tagOf(arg.getType());
            if (argTypeTag == 10 && arg.isConstant() && Double.isNaN(arg.getDouble(null))) {
                if (sigArgTypeTag == 6) {
                    args.setQuick(k, LongConstant.NULL);
                    continue;
                }
                if (sigArgTypeTag != 5) continue;
                args.setQuick(k, IntConstant.NULL);
                continue;
            }
            if ((argTypeTag == 11 || argTypeTag == 12) && sigArgTypeTag == 8) {
                int position = argPositions.getQuick(k);
                if (arg.isConstant()) {
                    long timestamp = this.convertToTimestamp(arg.getStr(null), position);
                    args.set(k, TimestampConstant.newInstance(timestamp));
                    continue;
                }
                AbstractCastToTimestampFunction castFn = argTypeTag == 11 ? new CastStrToTimestampFunctionFactory.Func(arg) : new CastSymbolToTimestampFunctionFactory.Func(arg);
                args.setQuick(k, castFn);
                continue;
            }
            if (argTypeTag != 19 || sigArgTypeTag != 11) continue;
            args.setQuick(k, new CastUuidToStrFunctionFactory.Func(arg));
        }
        return this.checkAndCreateFunction(candidate, args, argPositions, node, this.configuration);
    }

    @Nullable
    private Function createImplicitCastOrNull(int position, Function function, int toType) throws SqlException {
        int fromType = function.getType();
        switch (fromType) {
            case 11: 
            case 12: {
                if (toType == 19) {
                    return new CastStrToUuidFunctionFactory.Func(function);
                }
                if (toType == 8) {
                    return new CastStrToTimestampFunctionFactory.Func(function);
                }
                if (!ColumnType.isGeoHash(toType)) break;
                return CastStrToGeoHashFunctionFactory.newInstance(position, toType, function);
            }
            case 19: {
                if (toType != 11) break;
                return new CastUuidToStrFunctionFactory.Func(function);
            }
            default: {
                if (!ColumnType.isGeoHash(fromType)) break;
                int fromGeoBits = ColumnType.getGeoHashBits(fromType);
                int toGeoBits = ColumnType.getGeoHashBits(toType);
                if (!ColumnType.isGeoHash(toType) || toGeoBits >= fromGeoBits) break;
                return CastGeoHashToGeoHashFunctionFactory.newInstance(position, function, toType, fromType);
            }
        }
        return null;
    }

    private Function createIndexParameter(int variableIndex, int position) throws SqlException {
        Function function = this.getBindVariableService().getFunction(variableIndex);
        if (function == null) {
            return new IndexedParameterLinkFunction(variableIndex, 0, position);
        }
        return new IndexedParameterLinkFunction(variableIndex, function.getType(), position);
    }

    private Function createNamedParameter(int position, CharSequence name) throws SqlException {
        Function function = this.getBindVariableService().getFunction(name);
        if (function == null) {
            throw SqlException.position(position).put("undefined bind variable: ").put(name);
        }
        return new NamedParameterLinkFunction(Chars.toString(name), function.getType());
    }

    private Function functionToConstant(Function function) {
        Function newFunction = this.functionToConstant0(function);
        if (newFunction != function) {
            function.close();
        }
        return newFunction;
    }

    private Function functionToConstant0(Function function) {
        int type = function.getType();
        switch (ColumnType.tagOf(type)) {
            case 5: {
                if (function instanceof IntConstant) {
                    return function;
                }
                return IntConstant.newInstance(function.getInt(null));
            }
            case 1: {
                if (function instanceof BooleanConstant) {
                    return function;
                }
                return BooleanConstant.of(function.getBool(null));
            }
            case 2: {
                if (function instanceof ByteConstant) {
                    return function;
                }
                return ByteConstant.newInstance(function.getByte(null));
            }
            case 3: {
                if (function instanceof ShortConstant) {
                    return function;
                }
                return ShortConstant.newInstance(function.getShort(null));
            }
            case 4: {
                if (function instanceof CharConstant) {
                    return function;
                }
                return CharConstant.newInstance(function.getChar(null));
            }
            case 9: {
                if (function instanceof FloatConstant) {
                    return function;
                }
                return FloatConstant.newInstance(function.getFloat(null));
            }
            case 10: {
                if (function instanceof DoubleConstant) {
                    return function;
                }
                return DoubleConstant.newInstance(function.getDouble(null));
            }
            case 6: {
                if (function instanceof LongConstant) {
                    return function;
                }
                return LongConstant.newInstance(function.getLong(null));
            }
            case 13: {
                if (function instanceof Long256Constant) {
                    return function;
                }
                return new Long256Constant(function.getLong256A(null));
            }
            case 14: {
                if (function instanceof GeoByteConstant) {
                    return function;
                }
                return new GeoByteConstant(function.getGeoByte(null), type);
            }
            case 15: {
                if (function instanceof GeoShortConstant) {
                    return function;
                }
                return new GeoShortConstant(function.getGeoShort(null), type);
            }
            case 16: {
                if (function instanceof GeoIntConstant) {
                    return function;
                }
                return new GeoIntConstant(function.getGeoInt(null), type);
            }
            case 17: {
                if (function instanceof GeoLongConstant) {
                    return function;
                }
                return new GeoLongConstant(function.getGeoLong(null), type);
            }
            case 7: {
                if (function instanceof DateConstant) {
                    return function;
                }
                return DateConstant.getInstance(function.getDate(null));
            }
            case 11: {
                if (function instanceof StrConstant) {
                    return function;
                }
                return StrConstant.newInstance(function.getStr(null));
            }
            case 12: {
                if (function instanceof SymbolConstant) {
                    return function;
                }
                return SymbolConstant.newInstance(function.getSymbol(null));
            }
            case 8: {
                if (function instanceof TimestampConstant) {
                    return function;
                }
                return TimestampConstant.newInstance(function.getTimestamp(null));
            }
            case 19: {
                if (function instanceof UuidConstant) {
                    return function;
                }
                return new UuidConstant(function.getLong128Lo(null), function.getLong128Hi(null));
            }
        }
        return function;
    }

    @NotNull
    private BindVariableService getBindVariableService() throws SqlException {
        BindVariableService bindVariableService = this.sqlExecutionContext.getBindVariableService();
        if (bindVariableService == null) {
            throw SqlException.$(0, "bind variable service is not provided");
        }
        return bindVariableService;
    }

    private Function parseIndexedParameter(int position, CharSequence name) throws SqlException {
        try {
            int variableIndex = Numbers.parseInt(name, 1, name.length());
            if (variableIndex < 1) {
                throw SqlException.$(position, "invalid bind variable index [value=").put(variableIndex).put(']');
            }
            return this.createIndexParameter(variableIndex - 1, position);
        }
        catch (NumericException e) {
            throw SqlException.$(position, "invalid bind variable index [value=").put(name).put(']');
        }
    }

    static {
        int n = SqlCompiler.sqlControlSymbols.size();
        for (int i = 0; i < n; ++i) {
            FunctionFactoryCache.invalidFunctionNames.add(SqlCompiler.sqlControlSymbols.getQuick(i));
        }
        FunctionFactoryCache.invalidFunctionNameChars.add(32);
        FunctionFactoryCache.invalidFunctionNameChars.add(34);
        FunctionFactoryCache.invalidFunctionNameChars.add(39);
    }
}

