/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class SumFloatGroupByFunction
extends FloatFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public SumFloatGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        float value = this.arg.getFloat(record);
        if (value == value) {
            mapValue.putFloat(this.valueIndex, value);
        } else {
            mapValue.putFloat(this.valueIndex, 0.0f);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        float value = this.arg.getFloat(record);
        if (value == value) {
            mapValue.addFloat(this.valueIndex, value);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public float getFloat(Record rec) {
        return rec.getFloat(this.valueIndex);
    }

    @Override
    public String getName() {
        return "sum";
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(9);
    }

    @Override
    public void setFloat(MapValue mapValue, float value) {
        mapValue.putFloat(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putFloat(this.valueIndex, Float.NaN);
    }
}

