/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.SoftConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.SoftLongObjectCache;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB/\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001d\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/exodus/log/SeparateLogCache;", "Ljetbrains/exodus/log/LogCache;", "memoryUsage", "", "pageSize", "", "nonBlocking", "", "useSoftReferences", "cacheGenerationCount", "(JIZZI)V", "memoryUsagePercentage", "(IIZZI)V", "pagesCache", "Ljetbrains/exodus/core/dataStructures/LongObjectCacheBase;", "", "cachePage", "", "log", "Ljetbrains/exodus/log/Log;", "pageAddress", "page", "cacheKey", "pageArray", "clear", "getCachedPage", "getPage", "getPageIterable", "Ljetbrains/exodus/ArrayByteIterable;", "hitRate", "", "removePage", "removePage$xodus_environment", "xodus-environment"})
public final class SeparateLogCache
extends LogCache {
    @NotNull
    private final LongObjectCacheBase<byte[]> pagesCache;

    public SeparateLogCache(long memoryUsage, int pageSize, boolean nonBlocking, boolean useSoftReferences, int cacheGenerationCount) {
        super(memoryUsage, pageSize);
        int pagesCount = (int)(memoryUsage / (long)(pageSize + (useSoftReferences ? 144 : 80)));
        this.pagesCache = nonBlocking ? (useSoftReferences ? (LongObjectCacheBase)new SoftConcurrentLongObjectCache(pagesCount, cacheGenerationCount) : (LongObjectCacheBase)new ConcurrentLongObjectCache(pagesCount, cacheGenerationCount)) : (useSoftReferences ? (LongObjectCacheBase)new SoftLongObjectCache(pagesCount) : (LongObjectCacheBase)new LongObjectCache(pagesCount));
    }

    public SeparateLogCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking, boolean useSoftReferences, int cacheGenerationCount) {
        super(memoryUsagePercentage, pageSize);
        LongObjectCacheBase longObjectCacheBase;
        if (this.getMemoryUsage$xodus_environment() == Long.MAX_VALUE) {
            longObjectCacheBase = nonBlocking ? (useSoftReferences ? (LongObjectCacheBase)new SoftConcurrentLongObjectCache(8192, cacheGenerationCount) : (LongObjectCacheBase)new ConcurrentLongObjectCache(8192, cacheGenerationCount)) : (useSoftReferences ? (LongObjectCacheBase)new SoftLongObjectCache(8192) : (LongObjectCacheBase)new LongObjectCache());
        } else {
            int pagesCount = (int)(this.getMemoryUsage$xodus_environment() / (long)(pageSize + (useSoftReferences ? 144 : 80)));
            longObjectCacheBase = nonBlocking ? (useSoftReferences ? (LongObjectCacheBase)new SoftConcurrentLongObjectCache(pagesCount, cacheGenerationCount) : (LongObjectCacheBase)new ConcurrentLongObjectCache(pagesCount, cacheGenerationCount)) : (useSoftReferences ? (LongObjectCacheBase)new SoftLongObjectCache(pagesCount) : (LongObjectCacheBase)new LongObjectCache(pagesCount));
        }
        this.pagesCache = longObjectCacheBase;
    }

    @Override
    public void clear() {
        this.pagesCache.clear();
    }

    @Override
    public float hitRate() {
        return this.pagesCache.hitRate();
    }

    @Override
    public void cachePage(@NotNull Log log, long pageAddress, @NotNull byte[] page) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.cachePage(pageAddress, page);
    }

    @Override
    @NotNull
    protected ArrayByteIterable getPageIterable(@NotNull Log log, long pageAddress) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        byte[] page = (byte[])this.pagesCache.tryKeyLocked(pageAddress);
        if (page != null) {
            return new ArrayByteIterable(page);
        }
        page = log.getHighPage(pageAddress);
        if (page != null) {
            return new ArrayByteIterable(page, (int)Math.min(log.getHighAddress() - pageAddress, (long)this.getPageSize$xodus_environment()));
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(pageAddress, page);
        return new ArrayByteIterable(page);
    }

    @Override
    @NotNull
    public byte[] getPage(@NotNull Log log, long pageAddress) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        byte[] page = (byte[])this.pagesCache.tryKeyLocked(pageAddress);
        if (page != null) {
            return page;
        }
        page = log.getHighPage(pageAddress);
        if (page != null) {
            return page;
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(pageAddress, page);
        return page;
    }

    @Override
    @Nullable
    public byte[] getCachedPage(@NotNull Log log, long pageAddress) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        byte[] page = (byte[])this.pagesCache.getObjectLocked(pageAddress);
        if (page != null) {
            return page;
        }
        page = log.getHighPage(pageAddress);
        return page;
    }

    @Override
    public void removePage$xodus_environment(@NotNull Log log, long pageAddress) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.pagesCache.removeLocked(pageAddress);
    }

    private final void cachePage(long cacheKey, byte[] pageArray) {
        this.pagesCache.cacheObjectLocked(cacheKey, (Object)LogCache.postProcessTailPage(pageArray));
    }
}

