/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.api.WritableResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;

public abstract class AbstractWritableResult<T>
implements WritableResult<T> {
    protected final ResultType resultType;

    public AbstractWritableResult(ResultType resultType) {
        this.resultType = Objects.requireNonNull(resultType);
    }

    @Override
    public void write(PrintStream output) throws IOException {
        if (this.resultType == ResultType.JSON) {
            this.writeJsonResult(output);
        } else {
            this.writeSimpleResult(output);
        }
    }

    protected abstract void writeSimpleResult(PrintStream var1) throws IOException;

    protected void writeJsonResult(PrintStream output) throws IOException {
        JacksonUtils.write(this.getResult(), output);
    }
}

