/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.web.security.saml2.registration.Saml2CredentialProvider;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2X509Credential;

public class StandardSaml2CredentialProvider
implements Saml2CredentialProvider {
    @Override
    public Collection<Saml2X509Credential> getCredentials(KeyStore keyStore, char[] keyPassword) {
        Objects.requireNonNull(keyStore, "Key Store required");
        ArrayList<Saml2X509Credential> credentials = new ArrayList<Saml2X509Credential>();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (keyStore.isKeyEntry(alias)) {
                    this.processKeyEntry(keyStore, alias, keyPassword, credentials);
                    continue;
                }
                if (!keyStore.isCertificateEntry(alias)) continue;
                this.processCertificateEntry(keyStore, alias, credentials);
            }
        }
        catch (KeyStoreException e) {
            throw new Saml2Exception("Loading SAML Credentials failed", (Throwable)e);
        }
        return credentials;
    }

    private Key getKey(KeyStore keyStore, String alias, char[] keyPassword) {
        try {
            return keyStore.getKey(alias, keyPassword);
        }
        catch (GeneralSecurityException e) {
            throw new Saml2Exception(String.format("Loading Key [%s] failed", alias));
        }
    }

    private void processKeyEntry(KeyStore keyStore, String alias, char[] keyPassword, List<Saml2X509Credential> credentials) throws KeyStoreException {
        Key key = this.getKey(keyStore, alias, keyPassword);
        if (key instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)key;
            Certificate certificateEntry = keyStore.getCertificate(alias);
            if (certificateEntry instanceof X509Certificate) {
                X509Certificate certificate = (X509Certificate)certificateEntry;
                Saml2X509Credential credential = new Saml2X509Credential(privateKey, certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.SIGNING, Saml2X509Credential.Saml2X509CredentialType.DECRYPTION});
                credentials.add(credential);
            }
        }
    }

    private void processCertificateEntry(KeyStore keyStore, String alias, List<Saml2X509Credential> credentials) throws KeyStoreException {
        Certificate certificateEntry = keyStore.getCertificate(alias);
        if (certificateEntry instanceof X509Certificate) {
            X509Certificate certificate = (X509Certificate)certificateEntry;
            Saml2X509Credential credential = new Saml2X509Credential(certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.VERIFICATION, Saml2X509Credential.Saml2X509CredentialType.ENCRYPTION});
            credentials.add(credential);
        }
    }
}

