/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.provenance.lineage;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.List;
import org.apache.nifi.web.api.dto.util.TimestampAdapter;

@XmlType(name="provenanceNode")
public class ProvenanceNodeDTO {
    private String id;
    private String flowFileUuid;
    private List<String> parentUuids;
    private List<String> childUuids;
    private String clusterNodeIdentifier;
    private String type;
    private String eventType;
    private String componentType;
    private Long millis;
    private Date timestamp;

    @Schema(description="The id of the node.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The uuid of the flowfile associated with the provenance event.")
    public String getFlowFileUuid() {
        return this.flowFileUuid;
    }

    public void setFlowFileUuid(String flowFileUuid) {
        this.flowFileUuid = flowFileUuid;
    }

    @Schema(description="The uuid of the parent flowfiles of the provenance event.")
    public List<String> getParentUuids() {
        return this.parentUuids;
    }

    public void setParentUuids(List<String> parentUuids) {
        this.parentUuids = parentUuids;
    }

    @Schema(description="The uuid of the childrent flowfiles of the provenance event.")
    public List<String> getChildUuids() {
        return this.childUuids;
    }

    public void setChildUuids(List<String> childUuids) {
        this.childUuids = childUuids;
    }

    @Schema(description="The identifier of the node that this event/flowfile originated from.")
    public String getClusterNodeIdentifier() {
        return this.clusterNodeIdentifier;
    }

    public void setClusterNodeIdentifier(String clusterNodeIdentifier) {
        this.clusterNodeIdentifier = clusterNodeIdentifier;
    }

    @Schema(description="The type of the node.", allowableValues={"FLOWFILE", "EVENT"})
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Schema(description="If the type is EVENT, this is the type of event.")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Schema(description="If the type is EVENT, this is the type of the component that generated the event.")
    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @Schema(description="The timestamp of the node formatted.", type="string")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Schema(description="The timestamp of the node in milliseconds.")
    public Long getMillis() {
        return this.millis;
    }

    public void setMillis(Long millis) {
        this.millis = millis;
    }
}

