/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol;

import java.text.ParseException;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.ProtocolStatus;

public class ProtocolOutput {
    private Content content;
    private ProtocolStatus status;

    public ProtocolOutput(Content content, ProtocolStatus status) {
        this.content = content;
        this.status = status;
    }

    public ProtocolOutput(Content content) {
        this.content = content;
        this.status = ProtocolStatus.STATUS_SUCCESS;
        String lastModifiedDate = content.getMetadata().get("Last-Modified");
        if (lastModifiedDate != null) {
            try {
                long lastModified = HttpDateFormat.toLong(lastModifiedDate);
                this.status.setLastModified(lastModified);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public ProtocolStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProtocolStatus status) {
        this.status = status;
    }
}

