/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.File;
import java.text.NumberFormat;

public final class LogFileUtils {
    public static final String PRODUCER_SNAPSHOT_FILE_SUFFIX = ".snapshot";
    public static final String DELETED_FILE_SUFFIX = ".deleted";
    public static final String LOG_FILE_SUFFIX = ".log";
    public static final String INDEX_FILE_SUFFIX = ".index";
    public static final String TIME_INDEX_FILE_SUFFIX = ".timeindex";
    public static final String TXN_INDEX_FILE_SUFFIX = ".txnindex";

    private LogFileUtils() {
    }

    public static long offsetFromFileName(String fileName) {
        return Long.parseLong(fileName.substring(0, fileName.indexOf(46)));
    }

    public static File producerSnapshotFile(File logDir, long offset) {
        return new File(logDir, LogFileUtils.filenamePrefixFromOffset(offset) + PRODUCER_SNAPSHOT_FILE_SUFFIX);
    }

    public static String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public static File logFile(File dir, long offset) {
        return LogFileUtils.logFile(dir, offset, "");
    }

    public static File logFile(File dir, long offset, String suffix) {
        return new File(dir, LogFileUtils.filenamePrefixFromOffset(offset) + LOG_FILE_SUFFIX + suffix);
    }

    public static File offsetIndexFile(File dir, long offset) {
        return LogFileUtils.offsetIndexFile(dir, offset, "");
    }

    public static File offsetIndexFile(File dir, long offset, String suffix) {
        return new File(dir, LogFileUtils.filenamePrefixFromOffset(offset) + INDEX_FILE_SUFFIX + suffix);
    }

    public static File timeIndexFile(File dir, long offset) {
        return LogFileUtils.timeIndexFile(dir, offset, "");
    }

    public static File timeIndexFile(File dir, long offset, String suffix) {
        return new File(dir, LogFileUtils.filenamePrefixFromOffset(offset) + TIME_INDEX_FILE_SUFFIX + suffix);
    }

    public static File transactionIndexFile(File dir, long offset) {
        return LogFileUtils.transactionIndexFile(dir, offset, "");
    }

    public static File transactionIndexFile(File dir, long offset, String suffix) {
        return new File(dir, LogFileUtils.filenamePrefixFromOffset(offset) + TXN_INDEX_FILE_SUFFIX + suffix);
    }

    public static Long offsetFromFile(File file) {
        return LogFileUtils.offsetFromFileName(file.getName());
    }
}

