/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import java.io.File;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractRetryable;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.RetryTimeoutException;
import org.jodconverter.core.office.TemporaryException;
import org.jodconverter.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfficeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeUtils.class);

    public static @NonNull File getDefaultWorkingDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static void validateWorkingDir(@NonNull File workingDir) {
        if (!workingDir.isDirectory()) {
            throw new IllegalStateException("workingDir doesn't exist or is not a directory: " + workingDir);
        }
        if (!workingDir.canWrite()) {
            throw new IllegalStateException(String.format("workingDir '%s' cannot be written to", workingDir));
        }
    }

    public static void stopQuietly(@Nullable OfficeManager manager) {
        try {
            if (manager != null) {
                manager.stop();
            }
        }
        catch (OfficeException officeException) {
            // empty catch block
        }
    }

    public static void deleteOrRenameFile(@NonNull File file, long interval, long timeout) {
        block5: {
            if (!file.exists()) {
                return;
            }
            LOGGER.debug("Deleting '{}'", (Object)file);
            try {
                DeleteFileRetryable retryable = new DeleteFileRetryable(file);
                retryable.execute(interval, timeout);
            }
            catch (RetryTimeoutException deleteEx) {
                File oldFile = new File(file.getParentFile(), file.getName() + ".old." + System.currentTimeMillis());
                if (file.renameTo(oldFile)) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Could not delete '" + file + "'; renamed it to '" + oldFile + "'", (Throwable)deleteEx);
                    }
                }
                if (!LOGGER.isErrorEnabled()) break block5;
                LOGGER.error("Could not delete '" + file + "'", (Throwable)deleteEx);
            }
        }
    }

    private OfficeUtils() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }

    private static class DeleteFileRetryable
    extends AbstractRetryable<RuntimeException> {
        private final File file;

        private DeleteFileRetryable(File file) {
            this.file = file;
        }

        @Override
        protected void attempt() throws TemporaryException {
            try {
                FileUtils.delete(this.file);
                if (this.file.exists()) {
                    throw new TemporaryException("The file still exists");
                }
            }
            catch (IOException ex) {
                throw new TemporaryException(ex);
            }
        }
    }
}

