/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.user;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(OAuthUser.class);
    public static final String PARAM_LOGIN = "login";
    public static final String PARAM_EMAIL = "address.email";
    public static final String PARAM_FNAME = "firstname";
    public static final String PARAM_LNAME = "lastname";
    private final Map<String, String> userData;

    public OAuthUser(String jsonStr, OAuthServer server) {
        JSONObject json = OAuthUser.getJSON(jsonStr, server.getMapping().get(PARAM_LOGIN));
        HashMap<String, String> data = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : server.getMapping().entrySet()) {
            data.put(entry.getKey(), json.optString(entry.getValue()));
        }
        String login = (String)data.get(PARAM_LOGIN);
        String email = (String)data.get(PARAM_EMAIL);
        if (Strings.isEmpty((String)email)) {
            try {
                data.put(PARAM_EMAIL, String.format("%s@%s", login, new URL(server.getIconUrl()).getHost()));
            }
            catch (MalformedURLException e) {
                log.error("Failed to get user email from JSON: {}", (Object)json);
            }
        }
        this.userData = Collections.unmodifiableMap(data);
    }

    public OAuthUser(Map<String, String> umap) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(PARAM_LOGIN, umap.get(PARAM_LOGIN));
        data.put(PARAM_EMAIL, umap.get("email"));
        data.put(PARAM_FNAME, umap.get(PARAM_FNAME));
        data.put(PARAM_LNAME, umap.get(PARAM_LNAME));
        this.userData = Collections.unmodifiableMap(data);
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public String getLogin() {
        return this.userData.get(PARAM_LOGIN);
    }

    public String getEmail() {
        return this.userData.get(PARAM_EMAIL);
    }

    private static JSONObject getJSON(String str, String prop) {
        JSONObject res = OAuthUser.getJSON(new JSONObject(str), prop);
        return res == null ? new JSONObject() : res;
    }

    private static JSONObject getJSON(JSONObject json, String prop) {
        if (json.has(prop)) {
            return json;
        }
        for (String key : json.keySet()) {
            JSONObject jo;
            JSONObject res;
            Object o = json.get(key);
            if (o instanceof JSONArray) {
                JSONArray ja = (JSONArray)o;
                for (int i = 0; i < ja.length(); ++i) {
                    JSONObject jao = ja.getJSONObject(i);
                    JSONObject res2 = OAuthUser.getJSON(jao, prop);
                    if (res2 == null) continue;
                    return res2;
                }
                continue;
            }
            if (!(o instanceof JSONObject) || (res = OAuthUser.getJSON(jo = (JSONObject)o, prop)) == null) continue;
            return res;
        }
        return null;
    }
}

