/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.backup;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.openmeetings.backup.BackupImport;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.common.upload.UploadResourceReference;
import org.apache.openmeetings.web.util.ThreadHelper;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupUploadResourceReference
extends UploadResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BackupUploadResourceReference.class);
    @Inject
    private BackupImport backupImport;

    public BackupUploadResourceReference() {
        super(BackupUploadResourceReference.class, "backup-file-upload");
        Injector.get().inject((Object)this);
    }

    @Override
    protected boolean isUploadAllowed(Client c) {
        return Optional.ofNullable(c).map(Client::getUser).map(User::getRights).map(rights -> rights.contains(User.Right.ADMIN) || rights.contains(User.Right.ADMIN_BACKUP)).orElse(false);
    }

    @Override
    protected void processFiles(final Client c, List<FileItem> fileItems, final String uuid, MultipartServletWebRequest multiPartRequest) {
        ThreadHelper.startRunnable(() -> {
            final AtomicInteger lastProgress = new AtomicInteger(0);
            final AtomicInteger progress = new AtomicInteger(0);
            if (fileItems.isEmpty()) {
                this.sendError(c, uuid, "File is empty");
                return;
            }
            Timer timer = new Timer();
            try {
                FileItem fileItem = (FileItem)fileItems.get(0);
                if (fileItem.getInputStream() == null) {
                    this.sendError(c, uuid, "File is empty");
                    return;
                }
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        BackupUploadResourceReference.this.sendProgress(c, uuid, lastProgress, progress.get());
                    }
                }, 0L, 1000L);
                this.backupImport.performImport(fileItem.getInputStream(), progress);
            }
            catch (Exception e) {
                log.error("Exception on panel backup download ", (Throwable)e);
                this.sendError(c, uuid, e.getMessage() == null ? "Unexpected error" : e.getMessage());
            }
            finally {
                fileItems.forEach(fi -> {
                    try {
                        fi.delete();
                    }
                    catch (IOException e) {
                        log.error("IOException while deleting FileItem ", (Throwable)e);
                    }
                });
                timer.cancel();
            }
            this.sendProgress(c, uuid, lastProgress, 100);
        }, OpenmeetingsVariables.getApplicationName() + " - Restore");
    }
}

