/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.users;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.web.admin.users.UserForm;
import org.apache.openmeetings.web.admin.users.UsersPanel;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class PasswordDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final Form<String> form = new Form("form");
    private final PasswordTextField pass = new PasswordTextField("password", (IModel)Model.of((Serializable)((Object)"")));
    private SerializableConsumer<AjaxRequestTarget> action = null;
    @Inject
    private UserDao userDao;

    public PasswordDialog(String id) {
        super(id);
    }

    public UserForm getUserForm() {
        return (UserForm)((UsersPanel)((Object)this.findParent(UsersPanel.class))).get("form");
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("537"));
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("54"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{PasswordDialog.this.feedback});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                UserForm uf = PasswordDialog.this.getUserForm();
                if (uf.isAdminPassRequired()) {
                    if (PasswordDialog.this.userDao.verifyPassword(WebSession.getUserId(), (String)PasswordDialog.this.pass.getConvertedInput())) {
                        if (PasswordDialog.this.action != null) {
                            PasswordDialog.this.action.accept((Object)target);
                        }
                        PasswordDialog.this.close((IPartialPageRequestHandler)target);
                    } else {
                        PasswordDialog.this.form.error((Serializable)((Object)this.getString("error.bad.password")));
                        target.add(new Component[]{PasswordDialog.this.feedback});
                    }
                } else {
                    PasswordDialog.this.close((IPartialPageRequestHandler)target);
                }
            }
        });
        this.addButton((Component)OmModalCloseButton.of());
        this.add(new Component[]{this.form.add(new Component[]{this.feedback.setOutputMarkupId(true), this.pass.setRequired(false).setLabel((IModel)new ResourceModel("110")).setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true)})});
        super.onInitialize();
    }

    public Modal<String> show(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{(Component)this.pass.setModelObject((Object)"")});
        return super.show(handler);
    }

    public void setAction(SerializableConsumer<AjaxRequestTarget> action) {
        this.action = action;
    }
}

