/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapPutAllWithMetadataCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapPartitionMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.operation.MergeOperation;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.PassThroughMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.security.Permission;
import java.util.ArrayList;

public class MapPutAllWithMetadataMessageTask
extends AbstractMapPartitionMessageTask<MapPutAllWithMetadataCodec.RequestParameters> {
    private volatile long startTimeNanos;

    public MapPutAllWithMetadataMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        SerializationService ss = this.nodeEngine.getSerializationService();
        ArrayList<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> mergingEntries = new ArrayList<SplitBrainMergeTypes.MapMergeTypes<Object, Object>>();
        for (SimpleEntryView<Data, Data> entry : ((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).entries) {
            mergingEntries.add(MergingValueFactory.createMergingEntry(ss, entry));
        }
        SplitBrainMergePolicy mergePolicy = this.nodeEngine.getSplitBrainMergePolicyProvider().getMergePolicy(PassThroughMergePolicy.class.getName());
        return new MergeOperation(((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).name, mergingEntries, mergePolicy, true);
    }

    @Override
    protected MapPutAllWithMetadataCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapPutAllWithMetadataCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapPutAllWithMetadataCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void beforeProcess() {
        this.startTimeNanos = Timer.nanos();
    }

    @Override
    protected Object processResponseBeforeSending(Object response) {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).name).incrementPutLatencyNanos(((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).entries.size(), Timer.nanosElapsed(this.startTimeNanos));
        }
        return response;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).name, "put");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "putAllWithMetadata";
    }

    @Override
    public Object[] getParameters() {
        ArrayList<SimpleEntryView<Data, Data>> entries = new ArrayList<SimpleEntryView<Data, Data>>(((MapPutAllWithMetadataCodec.RequestParameters)this.parameters).entries);
        return new Object[]{entries};
    }
}

