/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ClientConnectivityLogger {
    private final ILogger logger;
    private final TaskScheduler executor;
    private final int delayPeriodSeconds;
    private Future<?> submittedLoggingTask;

    public ClientConnectivityLogger(LoggingService loggingService, TaskScheduler executor, HazelcastProperties properties) {
        this.logger = loggingService.getLogger(ClientConnectivityLogger.class);
        this.executor = executor;
        int periodSeconds = properties.getInteger(ClientProperty.CLIENT_CONNECTIVITY_LOGGING_DELAY_SECONDS);
        if (periodSeconds <= 0 && this.logger.isFineEnabled()) {
            this.logger.fine("Client connectivity logging is disabled.");
        }
        this.delayPeriodSeconds = periodSeconds;
    }

    public void submitLoggingTask(Collection<Member> connectedMembers, Collection<Member> allMembers) {
        if (this.delayPeriodSeconds <= 0) {
            return;
        }
        if (this.submittedLoggingTask != null && !this.submittedLoggingTask.isDone()) {
            this.submittedLoggingTask.cancel(true);
        }
        this.submittedLoggingTask = this.executor.schedule(() -> this.logger.info(this.connectivityLog(connectedMembers, allMembers)), (long)this.delayPeriodSeconds, TimeUnit.SECONDS);
    }

    private String connectivityLog(Collection<Member> connectedMembers, Collection<Member> allMembers) {
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Client Connectivity [");
        sb.append(allMembers.size());
        sb.append("] {");
        for (Member member : allMembers) {
            if (connectedMembers.contains(member)) {
                sb.append(System.lineSeparator()).append("\t").append(member).append(" - connected");
                continue;
            }
            sb.append(System.lineSeparator()).append("\t").append(member).append(" - disconnected");
        }
        sb.append(System.lineSeparator()).append("}").append(System.lineSeparator());
        return sb.toString();
    }

    public void terminate() {
        if (this.submittedLoggingTask != null && !this.submittedLoggingTask.isDone()) {
            this.submittedLoggingTask.cancel(true);
        }
    }
}

