/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.Objects;
import javax.annotation.Nonnull;

public class PersistentMemoryDirectoryConfig {
    private static final int NUMA_NODE_UNSET = -1;
    private String directory;
    private int numaNode = -1;

    public PersistentMemoryDirectoryConfig(@Nonnull String directory) {
        this.directory = Objects.requireNonNull(directory);
    }

    public PersistentMemoryDirectoryConfig(@Nonnull String directory, int numaNode) {
        this.directory = Objects.requireNonNull(directory);
        this.numaNode = numaNode;
    }

    public PersistentMemoryDirectoryConfig(@Nonnull PersistentMemoryDirectoryConfig directoryConfig) {
        this.directory = Objects.requireNonNull(directoryConfig).directory;
        this.numaNode = directoryConfig.numaNode;
    }

    @Nonnull
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(@Nonnull String directory) {
        this.directory = Objects.requireNonNull(directory);
    }

    public int getNumaNode() {
        return this.numaNode;
    }

    public void setNumaNode(int numaNode) {
        this.numaNode = numaNode;
    }

    public boolean isNumaNodeSet() {
        return this.numaNode != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentMemoryDirectoryConfig that = (PersistentMemoryDirectoryConfig)o;
        if (this.numaNode != that.numaNode) {
            return false;
        }
        return Objects.equals(this.directory, that.directory);
    }

    public int hashCode() {
        int result = this.directory != null ? this.directory.hashCode() : 0;
        result = 31 * result + this.numaNode;
        return result;
    }

    public String toString() {
        return "PersistentMemoryDirectoryConfig{directory='" + this.directory + "', numaNode=" + this.numaNode + "}";
    }
}

