/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.yaml;

import com.hazelcast.internal.config.yaml.EmptyNamedNodeMap;
import com.hazelcast.internal.config.yaml.EmptyNodeList;
import com.hazelcast.internal.config.yaml.NamedNodeMapAdapter;
import com.hazelcast.internal.config.yaml.NodeListMappingAdapter;
import com.hazelcast.internal.config.yaml.NodeListScalarAdapter;
import com.hazelcast.internal.config.yaml.NodeListSequenceAdapter;
import com.hazelcast.internal.config.yaml.W3cDomUtil;
import com.hazelcast.internal.yaml.MutableYamlScalar;
import com.hazelcast.internal.yaml.YamlCollection;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.internal.yaml.YamlScalar;
import com.hazelcast.internal.yaml.YamlSequence;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class YamlElementAdapter
implements Element {
    private final YamlNode yamlNode;

    YamlElementAdapter(YamlNode yamlNode) {
        this.yamlNode = yamlNode;
    }

    public YamlNode getYamlNode() {
        return this.yamlNode;
    }

    @Override
    public String getNodeName() {
        return this.yamlNode.nodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        YamlNode yamlNode = this.yamlNode;
        if (yamlNode instanceof YamlScalar) {
            YamlScalar scalar = (YamlScalar)yamlNode;
            Object nodeValue = scalar.nodeValue();
            return nodeValue != null ? nodeValue.toString() : null;
        }
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        YamlNode yamlNode = this.yamlNode;
        if (!(yamlNode instanceof MutableYamlScalar)) {
            throw new UnsupportedOperationException();
        }
        MutableYamlScalar scalar = (MutableYamlScalar)yamlNode;
        scalar.setValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public Node getParentNode() {
        return W3cDomUtil.asW3cNode(this.yamlNode.parent());
    }

    @Override
    public NodeList getChildNodes() {
        if (!this.hasChildNodes()) {
            return EmptyNodeList.emptyNodeList();
        }
        YamlNode yamlNode = this.yamlNode;
        if (yamlNode instanceof YamlMapping) {
            YamlMapping mapping = (YamlMapping)yamlNode;
            return new NodeListMappingAdapter(mapping);
        }
        yamlNode = this.yamlNode;
        if (yamlNode instanceof YamlSequence) {
            YamlSequence sequence = (YamlSequence)yamlNode;
            return new NodeListSequenceAdapter(sequence);
        }
        return new NodeListScalarAdapter((YamlScalar)this.yamlNode);
    }

    @Override
    public Node getFirstChild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getLastChild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getPreviousSibling() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getNextSibling() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedNodeMap getAttributes() {
        YamlNode yamlNode = this.yamlNode;
        if (yamlNode instanceof YamlMapping) {
            YamlMapping mapping = (YamlMapping)yamlNode;
            return new NamedNodeMapAdapter(mapping);
        }
        return EmptyNamedNodeMap.emptyNamedNodeMap();
    }

    @Override
    public Document getOwnerDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasChildNodes() {
        YamlCollection yamlCollection;
        YamlNode yamlNode = this.yamlNode;
        return yamlNode instanceof YamlCollection && (yamlCollection = (YamlCollection)yamlNode).childCount() > 0 || this.yamlNode instanceof YamlScalar;
    }

    @Override
    public Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void normalize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocalName() {
        return this.getNodeName();
    }

    @Override
    public boolean hasAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    public String getAttribute(String name) {
        YamlMapping mapping;
        YamlScalar yamlScalar;
        YamlNode yamlNode = this.yamlNode;
        if (yamlNode instanceof YamlMapping && (yamlScalar = (mapping = (YamlMapping)yamlNode).childAsScalar(name)) != null) {
            return yamlScalar.nodeValue().toString();
        }
        return "";
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attr getAttributeNode(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        Node element = this.getAttributes().getNamedItem(name);
        return W3cDomUtil.asNodeList(element);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributes().getNamedItem(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }
}

