/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.DefaultGarbageCollectorStats;
import com.hazelcast.internal.memory.GarbageCollectorStats;
import com.hazelcast.internal.util.SetUtil;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;

public final class GCStatsSupport {
    public static final Set<String> MINOR_GC;
    public static final Set<String> MAJOR_GC;

    private GCStatsSupport() {
    }

    static void fill(DefaultGarbageCollectorStats stats) {
        long minorCount = 0L;
        long minorTime = 0L;
        long majorCount = 0L;
        long majorTime = 0L;
        long unknownCount = 0L;
        long unknownTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = gc.getCollectionCount();
            if (count < 0L) continue;
            if (MINOR_GC.contains(gc.getName())) {
                minorCount += count;
                minorTime += gc.getCollectionTime();
                continue;
            }
            if (MAJOR_GC.contains(gc.getName())) {
                majorCount += count;
                majorTime += gc.getCollectionTime();
                continue;
            }
            unknownCount += count;
            unknownTime += gc.getCollectionTime();
        }
        stats.setMajorCount(majorCount);
        stats.setMajorTime(majorTime);
        stats.setMinorCount(minorCount);
        stats.setMinorTime(minorTime);
        stats.setUnknownCount(unknownCount);
        stats.setUnknownTime(unknownTime);
    }

    public static GarbageCollectorStats getGCStats() {
        DefaultGarbageCollectorStats stats = new DefaultGarbageCollectorStats();
        GCStatsSupport.fill(stats);
        return stats;
    }

    static {
        Set<String> minorGC = SetUtil.createHashSet(8);
        minorGC.add("PS Scavenge");
        minorGC.add("ParNew");
        minorGC.add("G1 Young Generation");
        minorGC.add("Copy");
        minorGC.add("ZGC");
        minorGC.add("Shenandoah Cycles");
        minorGC.add("ZGC Cycles");
        minorGC.add("ZGC Pauses");
        minorGC.add("ZGC Minor Cycles");
        minorGC.add("ZGC Minor Pauses");
        minorGC.add("partial gc");
        minorGC.add("scavenge");
        MINOR_GC = Collections.unmodifiableSet(minorGC);
        Set<String> majorGC = SetUtil.createHashSet(8);
        majorGC.add("PS MarkSweep");
        majorGC.add("ConcurrentMarkSweep");
        majorGC.add("G1 Old Generation");
        majorGC.add("G1 Mixed Generation");
        majorGC.add("MarkSweepCompact");
        majorGC.add("Shenandoah Pauses");
        majorGC.add("ZGC Major Cycles");
        majorGC.add("ZGC Major Pauses");
        majorGC.add("global");
        majorGC.add("global garbage collect");
        MAJOR_GC = Collections.unmodifiableSet(majorGC);
    }
}

