/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.FragmentedMigrationAwareService;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class ServiceNamespacesContext {
    private final Iterator<ServiceNamespace> namespaceIterator;
    private final Set<ServiceNamespace> allNamespaces = new HashSet<ServiceNamespace>();
    private final Map<ServiceNamespace, Collection<String>> namespaceToServices = new HashMap<ServiceNamespace, Collection<String>>();
    private ServiceNamespace currentNamespace;

    ServiceNamespacesContext(NodeEngineImpl nodeEngine, PartitionReplicationEvent event) {
        nodeEngine.forEachMatchingService(FragmentedMigrationAwareService.class, serviceInfo -> {
            Collection<ServiceNamespace> namespaces = this.getAllServiceNamespaces((ServiceInfo)serviceInfo, event);
            if (CollectionUtil.isNotEmpty(namespaces)) {
                this.allNamespaces.addAll(namespaces);
                namespaces.forEach(ns -> this.mapNamespaceToService((ServiceNamespace)ns, serviceInfo.getName()));
            }
        });
        this.allNamespaces.add(NonFragmentedServiceNamespace.INSTANCE);
        this.namespaceIterator = this.allNamespaces.iterator();
    }

    private void mapNamespaceToService(ServiceNamespace ns, String serviceName) {
        Collection<String> existingServiceNames = this.namespaceToServices.get(ns);
        if (existingServiceNames == null) {
            this.namespaceToServices.put(ns, Collections.singleton(serviceName));
            return;
        }
        if (existingServiceNames.size() == 1) {
            existingServiceNames = new HashSet<String>(existingServiceNames);
            this.namespaceToServices.put(ns, existingServiceNames);
        }
        existingServiceNames.add(serviceName);
    }

    private Collection<ServiceNamespace> getAllServiceNamespaces(ServiceInfo serviceInfo, PartitionReplicationEvent event) {
        return ((FragmentedMigrationAwareService)serviceInfo.getService()).getAllServiceNamespaces(event);
    }

    boolean hasNext() {
        return this.namespaceIterator.hasNext();
    }

    ServiceNamespace current() {
        return this.currentNamespace;
    }

    ServiceNamespace next() {
        this.currentNamespace = this.namespaceIterator.next();
        return this.currentNamespace;
    }

    Collection<String> getServiceNames(ServiceNamespace ns) {
        return this.namespaceToServices.get(ns);
    }

    Set<ServiceNamespace> getAllNamespaces() {
        return this.allNamespaces;
    }
}

