/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.accumulator;

public class DoubleAccumulator {
    private double value;

    public DoubleAccumulator() {
    }

    public DoubleAccumulator(double value) {
        this.value = value;
    }

    public DoubleAccumulator set(double value) {
        this.value = value;
        return this;
    }

    public DoubleAccumulator accumulate(double v) {
        this.value += v;
        return this;
    }

    public DoubleAccumulator combine(DoubleAccumulator that) {
        this.value += that.value;
        return this;
    }

    public DoubleAccumulator deduct(DoubleAccumulator that) {
        this.value -= that.value;
        return this;
    }

    public double export() {
        return this.value;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && Double.compare(this.value, ((DoubleAccumulator)o).value) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return "DoubleAccumulator(" + this.value + ")";
    }
}

