/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.ProcessorTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.ServiceFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class PartitionedProcessorTransform<T, K>
extends ProcessorTransform {
    private static final long serialVersionUID = 1L;
    private final FunctionEx<? super T, ? extends K> partitionKeyFn;

    private PartitionedProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorMetaSupplier processorSupplier, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        super(name, upstream, processorSupplier);
        this.partitionKeyFn = partitionKeyFn;
    }

    public static <T, K> PartitionedProcessorTransform<T, K> partitionedCustomProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorMetaSupplier processorSupplier, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>(name, upstream, processorSupplier, partitionKeyFn);
    }

    public static <S, T, K, R> PartitionedProcessorTransform<T, K> mapUsingServicePartitionedTransform(@Nonnull Transform upstream, @Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull BiFunctionEx<? super S, ? super T, ? extends R> mapFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("mapUsingPartitionedService", upstream, ProcessorMetaSupplier.of(PartitionedProcessorTransform.getPreferredLP(serviceFactory), serviceFactory.permission(), Processors.mapUsingServiceP(serviceFactory, mapFn)), partitionKeyFn);
    }

    public static <S, T, K> PartitionedProcessorTransform<T, K> filterUsingServicePartitionedTransform(@Nonnull Transform upstream, @Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull BiPredicateEx<? super S, ? super T> filterFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("filterUsingPartitionedService", upstream, ProcessorMetaSupplier.of(PartitionedProcessorTransform.getPreferredLP(serviceFactory), serviceFactory.permission(), Processors.filterUsingServiceP(serviceFactory, filterFn)), partitionKeyFn);
    }

    public static <S, T, K, R> PartitionedProcessorTransform<T, K> flatMapUsingServicePartitionedTransform(@Nonnull Transform upstream, @Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull BiFunctionEx<? super S, ? super T, ? extends Traverser<R>> flatMapFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("flatMapUsingPartitionedService", upstream, ProcessorMetaSupplier.of(PartitionedProcessorTransform.getPreferredLP(serviceFactory), serviceFactory.permission(), Processors.flatMapUsingServiceP(serviceFactory, flatMapFn)), partitionKeyFn);
    }

    public static <S, T, K, R> PartitionedProcessorTransform<T, K> flatMapUsingServiceAsyncPartitionedTransform(@Nonnull Transform upstream, @Nonnull String operationName, @Nonnull ServiceFactory<?, S> serviceFactory, int maxConcurrentOps, boolean preserveOrder, @Nonnull BiFunctionEx<? super S, ? super T, CompletableFuture<Traverser<R>>> flatMapAsyncFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        String name = operationName + "UsingPartitionedServiceAsync";
        ProcessorSupplier supplier = PartitionedProcessorTransform.flatMapUsingServiceAsyncP(serviceFactory, maxConcurrentOps, preserveOrder, partitionKeyFn, flatMapAsyncFn);
        ProcessorMetaSupplier metaSupplier = ProcessorMetaSupplier.of(PartitionedProcessorTransform.getPreferredLP(serviceFactory), serviceFactory.permission(), supplier);
        return new PartitionedProcessorTransform<T, K>(name, upstream, metaSupplier, partitionKeyFn);
    }

    public static <S, T, K, R> PartitionedProcessorTransform<T, K> flatMapUsingServiceAsyncBatchedPartitionedTransform(@Nonnull Transform upstream, @Nonnull String operationName, @Nonnull ServiceFactory<?, S> serviceFactory, int maxConcurrentOps, int maxBatchSize, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<Traverser<R>>> flatMapAsyncFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        String name = operationName + "UsingPartitionedServiceAsync";
        ProcessorSupplier supplier = PartitionedProcessorTransform.flatMapUsingServiceAsyncBatchedP(serviceFactory, maxConcurrentOps, maxBatchSize, flatMapAsyncFn);
        ProcessorMetaSupplier metaSupplier = ProcessorMetaSupplier.of(PartitionedProcessorTransform.getPreferredLP(serviceFactory), serviceFactory.permission(), supplier);
        return new PartitionedProcessorTransform<T, K>(name, upstream, metaSupplier, partitionKeyFn);
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        this.determineLocalParallelism(this.processorSupplier.preferredLocalParallelism(), context, p.isPreserveOrder());
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.determinedLocalParallelism(), this.processorSupplier);
        p.addEdges((Transform)this, pv.v, e -> e.partitioned(this.partitionKeyFn).distributed());
    }
}

