/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.memory.AccumulationLimitExceededException;
import java.util.Comparator;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SortP<T>
extends AbstractProcessor {
    private final PriorityQueue<T> priorityQueue;
    private final Traverser<T> resultTraverser;
    private long maxItems;

    public SortP(@Nullable Comparator<T> comparator) {
        this.priorityQueue = new PriorityQueue<T>(comparator);
        this.resultTraverser = this.priorityQueue::poll;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.maxItems = context.maxProcessorAccumulatedRecords();
    }

    @Override
    protected boolean tryProcess0(@Nonnull Object item) {
        if ((long)this.priorityQueue.size() == this.maxItems) {
            throw new AccumulationLimitExceededException();
        }
        this.priorityQueue.add(item);
        return true;
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.resultTraverser);
    }

    @Override
    public boolean closeIsCooperative() {
        return true;
    }
}

