/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.kubernetes.FileReaderTokenProvider;
import com.hazelcast.kubernetes.KubernetesProperties;
import com.hazelcast.kubernetes.KubernetesTokenProvider;
import com.hazelcast.kubernetes.StaticTokenProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;

final class KubernetesConfig {
    private static final String DEFAULT_MASTER_URL = "https://kubernetes.default.svc";
    private static final String DEFAULT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final int DEFAULT_SERVICE_DNS_TIMEOUT_SECONDS = 5;
    private static final int DEFAULT_KUBERNETES_API_RETRIES = 3;
    private final String serviceDns;
    private final int serviceDnsTimeout;
    private final String serviceName;
    private final String serviceLabelName;
    private final String serviceLabelValue;
    private final String namespace;
    private final String podLabelName;
    private final String podLabelValue;
    private final boolean resolveNotReadyAddresses;
    private final ExposeExternallyMode exposeExternallyMode;
    private final boolean useNodeNameAsExternalAddress;
    private final String servicePerPodLabelName;
    private final String servicePerPodLabelValue;
    private final int kubernetesApiRetries;
    private final String kubernetesMasterUrl;
    private final String kubernetesCaCertificate;
    private final int servicePort;
    private final FileContentsReader fileContentsReader;
    private final KubernetesTokenProvider tokenProvider;

    KubernetesConfig(Map<String, Comparable> properties) {
        this(properties, new DefaultFileContentsReader());
    }

    KubernetesConfig(Map<String, Comparable> properties, FileContentsReader fileContentsReader) {
        this.fileContentsReader = fileContentsReader;
        this.serviceDns = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_DNS);
        this.serviceDnsTimeout = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_DNS_TIMEOUT, 5);
        this.serviceName = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_NAME);
        this.serviceLabelName = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_LABEL_NAME);
        this.serviceLabelValue = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_LABEL_VALUE, "true");
        this.podLabelName = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.POD_LABEL_NAME);
        this.podLabelValue = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.POD_LABEL_VALUE);
        this.resolveNotReadyAddresses = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.RESOLVE_NOT_READY_ADDRESSES, true);
        this.useNodeNameAsExternalAddress = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.USE_NODE_NAME_AS_EXTERNAL_ADDRESS, false);
        this.exposeExternallyMode = this.getExposeExternallyMode(properties);
        this.servicePerPodLabelName = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_PER_POD_LABEL_NAME);
        this.servicePerPodLabelValue = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_PER_POD_LABEL_VALUE);
        this.kubernetesApiRetries = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_API_RETIRES, 3);
        this.kubernetesMasterUrl = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_MASTER_URL, DEFAULT_MASTER_URL);
        this.tokenProvider = this.buildTokenProvider(properties);
        this.kubernetesCaCertificate = this.caCertificate(properties);
        this.servicePort = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_PORT, 0);
        this.namespace = this.getNamespaceWithFallbacks(properties, "hazelcast.kubernetes.", KubernetesProperties.NAMESPACE);
        this.validateConfig();
    }

    private ExposeExternallyMode getExposeExternallyMode(Map<String, Comparable> properties) {
        Boolean exposeExternally = (Boolean)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.EXPOSE_EXTERNALLY);
        if (exposeExternally == null) {
            return ExposeExternallyMode.AUTO;
        }
        if (exposeExternally.booleanValue()) {
            return ExposeExternallyMode.ENABLED;
        }
        return ExposeExternallyMode.DISABLED;
    }

    private String getNamespaceWithFallbacks(Map<String, Comparable> properties, String kubernetesSystemPrefix, PropertyDefinition propertyDefinition) {
        String namespace = (String)this.getOrNull(properties, kubernetesSystemPrefix, propertyDefinition);
        if (namespace == null) {
            namespace = System.getenv("KUBERNETES_NAMESPACE");
        }
        if (namespace == null) {
            namespace = System.getenv("OPENSHIFT_BUILD_NAMESPACE");
        }
        if (namespace == null && this.getMode() == DiscoveryMode.KUBERNETES_API) {
            namespace = this.readNamespace();
        }
        return namespace;
    }

    private KubernetesTokenProvider buildTokenProvider(Map<String, Comparable> properties) {
        String apiToken = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_API_TOKEN);
        KubernetesTokenProvider apiTokenProvider = apiToken == null && this.getMode() == DiscoveryMode.KUBERNETES_API ? new FileReaderTokenProvider(DEFAULT_TOKEN_PATH) : new StaticTokenProvider(apiToken);
        return apiTokenProvider;
    }

    private String caCertificate(Map<String, Comparable> properties) {
        String caCertificate = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_CA_CERTIFICATE);
        if (caCertificate == null && this.getMode() == DiscoveryMode.KUBERNETES_API) {
            caCertificate = this.readCaCertificate();
        }
        return caCertificate;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private String readCaCertificate() {
        return this.fileContentsReader.readFileContents("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private String readNamespace() {
        return this.fileContentsReader.readFileContents("/var/run/secrets/kubernetes.io/serviceaccount/namespace");
    }

    private <T extends Comparable> T getOrNull(Map<String, Comparable> properties, String prefix, PropertyDefinition property) {
        return this.getOrDefault(properties, prefix, property, null);
    }

    private <T extends Comparable> T getOrDefault(Map<String, Comparable> properties, String prefix, PropertyDefinition property, T defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        Comparable value = this.readProperty(prefix, property);
        if (value == null) {
            value = properties.get(property.key());
        }
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    private Comparable readProperty(String prefix, PropertyDefinition property) {
        if (prefix != null) {
            String p = this.getProperty(prefix, property);
            String v = System.getProperty(p);
            if (StringUtil.isNullOrEmpty(v) && StringUtil.isNullOrEmpty(v = System.getenv(p))) {
                v = System.getenv(this.cIdentifierLike(p));
            }
            if (!StringUtil.isNullOrEmpty(v)) {
                return property.typeConverter().convert((Comparable)((Object)v));
            }
        }
        return null;
    }

    private String cIdentifierLike(String property) {
        property = property.toUpperCase();
        property = property.replace(".", "_");
        return property.replace("-", "_");
    }

    private String getProperty(String prefix, PropertyDefinition property) {
        StringBuilder sb = new StringBuilder(prefix);
        if (prefix.charAt(prefix.length() - 1) != '.') {
            sb.append('.');
        }
        return sb.append(property.key()).toString();
    }

    private void validateConfig() {
        if (!(StringUtil.isNullOrEmptyAfterTrim(this.serviceDns) || StringUtil.isNullOrEmptyAfterTrim(this.serviceName) && StringUtil.isNullOrEmptyAfterTrim(this.serviceLabelName) && StringUtil.isNullOrEmptyAfterTrim(this.podLabelName))) {
            throw new InvalidConfigurationException(String.format("Properties '%s' and ('%s' or '%s' or %s) cannot be defined at the same time", KubernetesProperties.SERVICE_DNS.key(), KubernetesProperties.SERVICE_NAME.key(), KubernetesProperties.SERVICE_LABEL_NAME.key(), KubernetesProperties.POD_LABEL_NAME.key()));
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.serviceName) && !StringUtil.isNullOrEmptyAfterTrim(this.serviceLabelName)) {
            throw new InvalidConfigurationException(String.format("Properties '%s' and '%s' cannot be defined at the same time", KubernetesProperties.SERVICE_NAME.key(), KubernetesProperties.SERVICE_LABEL_NAME.key()));
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.serviceName) && !StringUtil.isNullOrEmptyAfterTrim(this.podLabelName)) {
            throw new InvalidConfigurationException(String.format("Properties '%s' and '%s' cannot be defined at the same time", KubernetesProperties.SERVICE_NAME.key(), KubernetesProperties.POD_LABEL_NAME.key()));
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.serviceLabelName) && !StringUtil.isNullOrEmptyAfterTrim(this.podLabelName)) {
            throw new InvalidConfigurationException(String.format("Properties '%s' and '%s' cannot be defined at the same time", KubernetesProperties.SERVICE_LABEL_NAME.key(), KubernetesProperties.POD_LABEL_NAME.key()));
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.serviceLabelName) && !StringUtil.isNullOrEmptyAfterTrim(this.serviceLabelValue) && this.serviceLabelName.chars().filter(ch -> ch == 44).count() != this.serviceLabelValue.chars().filter(ch -> ch == 44).count()) {
            throw new InvalidConfigurationException(String.format("Properties '%s' and '%s' must have the same number of comma separated elements", KubernetesProperties.SERVICE_LABEL_NAME.key(), KubernetesProperties.SERVICE_LABEL_VALUE.key()));
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.podLabelName) && !StringUtil.isNullOrEmptyAfterTrim(this.podLabelValue) && this.podLabelName.chars().filter(ch -> ch == 44).count() != this.podLabelValue.chars().filter(ch -> ch == 44).count()) {
            throw new InvalidConfigurationException(String.format("Properties '%s' and '%s' must have the same number of comma separated elements", KubernetesProperties.POD_LABEL_NAME.key(), KubernetesProperties.POD_LABEL_VALUE.key()));
        }
        if (this.serviceDnsTimeout < 0) {
            throw new InvalidConfigurationException(String.format("Property '%s' cannot be a negative number", KubernetesProperties.SERVICE_DNS_TIMEOUT.key()));
        }
        if (this.kubernetesApiRetries < 0) {
            throw new InvalidConfigurationException(String.format("Property '%s' cannot be a negative number", KubernetesProperties.KUBERNETES_API_RETIRES.key()));
        }
        if (this.servicePort < 0) {
            throw new InvalidConfigurationException(String.format("Property '%s' cannot be a negative number", KubernetesProperties.SERVICE_PORT.key()));
        }
    }

    DiscoveryMode getMode() {
        if (!StringUtil.isNullOrEmptyAfterTrim(this.serviceDns)) {
            return DiscoveryMode.DNS_LOOKUP;
        }
        return DiscoveryMode.KUBERNETES_API;
    }

    String getServiceDns() {
        return this.serviceDns;
    }

    int getServiceDnsTimeout() {
        return this.serviceDnsTimeout;
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getServiceLabelName() {
        return this.serviceLabelName;
    }

    String getServiceLabelValue() {
        return this.serviceLabelValue;
    }

    String getNamespace() {
        return this.namespace;
    }

    public String getPodLabelName() {
        return this.podLabelName;
    }

    public String getPodLabelValue() {
        return this.podLabelValue;
    }

    public ExposeExternallyMode getExposeExternallyMode() {
        return this.exposeExternallyMode;
    }

    public String getServicePerPodLabelName() {
        return this.servicePerPodLabelName;
    }

    public String getServicePerPodLabelValue() {
        return this.servicePerPodLabelValue;
    }

    boolean isResolveNotReadyAddresses() {
        return this.resolveNotReadyAddresses;
    }

    boolean isUseNodeNameAsExternalAddress() {
        return this.useNodeNameAsExternalAddress;
    }

    int getKubernetesApiRetries() {
        return this.kubernetesApiRetries;
    }

    String getKubernetesMasterUrl() {
        return this.kubernetesMasterUrl;
    }

    String getKubernetesCaCertificate() {
        return this.kubernetesCaCertificate;
    }

    int getServicePort() {
        return this.servicePort;
    }

    KubernetesTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public String toString() {
        return "Kubernetes Discovery properties: { service-dns: " + this.serviceDns + ", service-dns-timeout: " + this.serviceDnsTimeout + ", service-name: " + this.serviceName + ", service-port: " + this.servicePort + ", service-label: " + this.serviceLabelName + ", service-label-value: " + this.serviceLabelValue + ", namespace: " + this.namespace + ", pod-label: " + this.podLabelName + ", pod-label-value: " + this.podLabelValue + ", resolve-not-ready-addresses: " + this.resolveNotReadyAddresses + ", expose-externally-mode: " + this.exposeExternallyMode.name() + ", use-node-name-as-external-address: " + this.useNodeNameAsExternalAddress + ", service-per-pod-label: " + this.servicePerPodLabelName + ", service-per-pod-label-value: " + this.servicePerPodLabelValue + ", kubernetes-api-retries: " + this.kubernetesApiRetries + ", kubernetes-master: " + this.kubernetesMasterUrl + "}";
    }

    static class DefaultFileContentsReader
    implements FileContentsReader {
        DefaultFileContentsReader() {
        }

        @Override
        public String readFileContents(String fileName) {
            try {
                return Files.readString(Paths.get(fileName, new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not get " + fileName, e);
            }
        }
    }

    @FunctionalInterface
    static interface FileContentsReader {
        public String readFileContents(String var1);
    }

    static enum ExposeExternallyMode {
        AUTO,
        ENABLED,
        DISABLED;

    }

    static enum DiscoveryMode {
        DNS_LOOKUP,
        KUBERNETES_API;

    }
}

