/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.writebehind.BoundedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.CoalescedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.CyclicWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.NodeWideUsedCapacityCounter;
import com.hazelcast.map.impl.mapstore.writebehind.SynchronizedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;

public final class WriteBehindQueues {
    private WriteBehindQueues() {
    }

    public static WriteBehindQueue<DelayedEntry> createDefaultWriteBehindQueue() {
        return WriteBehindQueues.createSynchronizedWriteBehindQueue(WriteBehindQueues.createCoalescedWriteBehindQueue());
    }

    public static WriteBehindQueue<DelayedEntry> createBoundedWriteBehindQueue(MapStoreContext mapStoreContext) {
        NodeWideUsedCapacityCounter counter = mapStoreContext.getMapServiceContext().getNodeWideUsedCapacityCounter();
        return WriteBehindQueues.createSynchronizedWriteBehindQueue(WriteBehindQueues.createBoundedWriteBehindQueue(WriteBehindQueues.createCyclicWriteBehindQueue(), counter));
    }

    static WriteBehindQueue<DelayedEntry> createCoalescedWriteBehindQueue() {
        return new CoalescedWriteBehindQueue();
    }

    static <T extends DelayedEntry> WriteBehindQueue<T> createBoundedWriteBehindQueue(WriteBehindQueue<T> queue, NodeWideUsedCapacityCounter counter) {
        return new BoundedWriteBehindQueue<T>(queue, counter);
    }

    private static <T> WriteBehindQueue<T> createSynchronizedWriteBehindQueue(WriteBehindQueue<T> queue) {
        return new SynchronizedWriteBehindQueue<T>(queue);
    }

    private static WriteBehindQueue<DelayedEntry> createCyclicWriteBehindQueue() {
        return new CyclicWriteBehindQueue();
    }
}

