/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.management.dto.SlowOperationDTO;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.PartitionTaskFactory;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface OperationService {
    public static final String SERVICE_NAME = "hz:impl:operationService";

    public int getResponseQueueSize();

    public int getOperationExecutorQueueSize();

    public int getPriorityOperationExecutorQueueSize();

    public int getRunningOperationsCount();

    public int getRemoteOperationsCount();

    public long getExecutedOperationCount();

    public int getPartitionThreadCount();

    public int getGenericThreadCount();

    public void run(Operation var1);

    public void execute(Operation var1);

    public void execute(PartitionSpecificRunnable var1);

    public void executeOnPartitions(PartitionTaskFactory var1, BitSet var2);

    public <E> InvocationFuture<E> invokeOnPartition(String var1, Operation var2, int var3);

    public <E> InvocationFuture<E> invokeOnPartitionAsync(String var1, Operation var2, int var3);

    public <E> InvocationFuture<E> invokeOnPartitionAsync(String var1, Operation var2, int var3, int var4);

    public <E> InvocationFuture<E> invokeOnPartition(Operation var1);

    public <E> InvocationFuture<E> invokeOnTarget(String var1, Operation var2, Address var3);

    public <E> InvocationFuture<E> invokeOnTargetAsync(String var1, Operation var2, Address var3);

    public <E> InvocationFuture<E> invokeOnMaster(String var1, Operation var2);

    public InvocationBuilder createInvocationBuilder(String var1, Operation var2, int var3);

    public InvocationBuilder createInvocationBuilder(String var1, Operation var2, Address var3);

    public InvocationBuilder createMasterInvocationBuilder(String var1, Operation var2);

    public Map<Integer, Object> invokeOnAllPartitions(String var1, OperationFactory var2) throws Exception;

    public <T> CompletableFuture<Map<Integer, T>> invokeOnAllPartitionsAsync(String var1, OperationFactory var2);

    public <T> Map<Integer, T> invokeOnPartitions(String var1, OperationFactory var2, Collection<Integer> var3) throws Exception;

    public <T> CompletableFuture<Map<Integer, T>> invokeOnPartitionsAsync(String var1, OperationFactory var2, Collection<Integer> var3);

    public <T> CompletableFuture<Map<Integer, T>> invokeOnPartitionsAsync(String var1, OperationFactory var2, Map<Address, List<Integer>> var3);

    public Map<Integer, Object> invokeOnPartitions(String var1, OperationFactory var2, int[] var3) throws Exception;

    public boolean send(Operation var1, Address var2);

    public void onStartAsyncOperation(Operation var1);

    public void onCompletionAsyncOperation(Operation var1);

    public boolean isCallTimedOut(Operation var1);

    public boolean isRunAllowed(Operation var1);

    public List<SlowOperationDTO> getSlowOperationDTOs();

    public void onEndpointLeft(Address var1);
}

