/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.cxf.feature.Features;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.openmeetings.core.data.file.FileProcessor;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.dto.file.FileExplorerObject;
import org.apache.openmeetings.db.dto.file.FileItemDTO;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.error.InternalServiceException;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.apache.openmeetings.webservice.schema.FileExplorerObjectWrapper;
import org.apache.openmeetings.webservice.schema.FileItemDTOListWrapper;
import org.apache.openmeetings.webservice.schema.FileItemDTOWrapper;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fileWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.FileWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="FileService")
@Path(value="/file")
public class FileWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(FileWebService.class);
    @Inject
    private FileProcessor fileProcessor;

    @DELETE
    @Path(value="/{id}")
    @Operation(description="deletes files or folders based on it id", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult delete(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the id of the file or folder") @PathParam(value="id") @WebParam(name="id") Long id) throws ServiceException {
        FileItem f = this.fileDao.get(id);
        return this.performCall(sid, (Sessiondata sd) -> {
            Long userId = sd.getUserId();
            Set<User.Right> rights = this.getRights(userId);
            return AuthLevelUtil.hasWebServiceLevel(rights) || AuthLevelUtil.hasUserLevel(rights) && userId.equals(f.getOwnerId());
        }, (Sessiondata sd) -> {
            if (f == null) {
                return new ServiceResult("Bad id", ServiceResult.Type.ERROR);
            }
            this.fileDao.delete((BaseFileItem)f);
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }

    @DELETE
    @Path(value="/{externaltype}/{externalid}")
    @Operation(description="deletes a file by its external Id and type", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult deleteExternal(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the externalType") @WebParam(name="externaltype") @PathParam(value="externaltype") String externalType, @Parameter(required=true, description="the id of the file or folder") @WebParam(name="externalid") @PathParam(value="externalid") String externalId) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            FileItem f = this.fileDao.get(externalId, externalType);
            this.fileDao.delete((BaseFileItem)f);
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/")
    @Operation(description="to add a folder to the private drive, set parentId = 0 and isOwner to 1/true and\n externalUserId/externalUserType to a valid USER", responses={@ApiResponse(responseCode="200", description="Object created", content={@Content(schema=@Schema(implementation=FileItemDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public FileItemDTO add(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the The file attributes to be added") @Multipart(value="file", type="application/json") @WebParam(name="file") FileItemDTO file, @Parameter(required=true, description="the The file to be added") @Multipart(value="stream", type="application/octet-stream", required=false) @WebParam(name="stream") InputStream stream) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            FileItem f;
            block5: {
                FileItem fileItem = f = file == null ? null : file.get();
                if (f == null || f.getId() != null) {
                    throw new InternalServiceException("Bad id");
                }
                f.setInsertedBy(sd.getUserId());
                if (stream != null) {
                    try {
                        ProcessResultList result = this.fileProcessor.processFile(f, stream, Optional.empty());
                        if (result.hasError()) {
                            throw new ServiceException(result.getLogMessage());
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        throw new InternalServiceException(e.getMessage());
                    }
                }
                f = this.fileDao.update(f);
            }
            return new FileItemDTO(f);
        });
    }

    @WebMethod
    @GET
    @Path(value="/{externaltype}")
    @Operation(description="Get all files by external type", responses={@ApiResponse(responseCode="200", description="the list of files for given external type", content={@Content(schema=@Schema(implementation=FileItemDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<FileItemDTO> getAllExternal(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="External type for file listing") @WebParam(name="externaltype") @PathParam(value="externaltype") String externalType) throws ServiceException {
        log.debug("getAllExternal::externalType {}", (Object)externalType);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> FileItemDTO.list((List)this.fileDao.getExternal(externalType)));
    }

    @WebMethod
    @GET
    @Path(value="/room/{id}")
    @Operation(description="Get a File Explorer Object by a given ROOM", responses={@ApiResponse(responseCode="200", description="File Explorer Object by a given ROOM", content={@Content(schema=@Schema(implementation=FileExplorerObjectWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public FileExplorerObject getRoom(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="ROOM Id") @WebParam(name="id") @PathParam(value="id") long roomId) throws ServiceException {
        log.debug("getRoom::roomId {}", (Object)roomId);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            FileExplorerObject fileExplorerObject = new FileExplorerObject();
            List fList = this.fileDao.getByOwner(sd.getUserId());
            fileExplorerObject.setUser(fList, this.fileDao.getSize(fList));
            List rList = this.fileDao.getByRoom(Long.valueOf(roomId));
            fileExplorerObject.setRoom(rList, this.fileDao.getSize(rList));
            return fileExplorerObject;
        });
    }

    @WebMethod
    @GET
    @Path(value="/room/{id}/{parent}")
    @Operation(description="Get list of FileItemDTO by parent", responses={@ApiResponse(responseCode="200", description="list of file explorer items", content={@Content(schema=@Schema(implementation=FileItemDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<FileItemDTO> getRoomByParent(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the parent folder id") @WebParam(name="id") @PathParam(value="id") long roomId, @Parameter(required=true, description="the room id") @WebParam(name="parent") @PathParam(value="parent") long parentId) throws ServiceException {
        log.debug("getRoomByParent {}", (Object)parentId);
        return this.performCall(sid, User.Right.ROOM, (Sessiondata sd) -> {
            List list = parentId < 0L ? (parentId == -1L ? this.fileDao.getByOwner(sd.getUserId()) : this.fileDao.getByRoom(Long.valueOf(roomId))) : this.fileDao.getByParent(Long.valueOf(parentId));
            return FileItemDTO.list((List)list);
        });
    }

    @WebMethod
    @POST
    @Path(value="/rename/{id}/{name}")
    @Operation(description="update a file or folder name", responses={@ApiResponse(responseCode="200", description="resulting file object", content={@Content(schema=@Schema(implementation=FileItemDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public FileItemDTO rename(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="file or folder id") @WebParam(name="id") @PathParam(value="id") long id, @Parameter(required=true, description="new file or folder name") @WebParam(name="name") @PathParam(value="name") String name) throws ServiceException {
        log.debug("rename {}", (Object)id);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            FileItem f = this.fileDao.rename(Long.valueOf(id), name);
            return f == null ? null : new FileItemDTO(f);
        });
    }

    @WebMethod
    @POST
    @Path(value="/move/{roomid}/{id}/{parentid}")
    @Operation(description="move a file or folder", responses={@ApiResponse(responseCode="200", description="resulting file object", content={@Content(schema=@Schema(implementation=FileItemDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public FileItemDTO move(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="current file or folder id to be moved") @WebParam(name="id") @PathParam(value="id") long id, @Parameter(required=true, description="room this file need to be moved") @WebParam(name="roomid") @PathParam(value="roomid") long roomId, @Parameter(required=true, description="new parent folder id") @WebParam(name="parentid") @PathParam(value="parentid") long parentId) throws ServiceException {
        log.debug("move {}", (Object)id);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            FileItem f = this.fileDao.move(id, parentId, sd.getUserId().longValue(), roomId);
            return f == null ? null : new FileItemDTO(f);
        });
    }
}

