/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.interceptor.AroundInvoke;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.DecoratorHandler;
import org.apache.webbeans.intercept.DefaultInterceptorHandler;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.OwbInterceptorProxy;

public abstract class AbstractProducer<T>
implements Producer<T> {
    private Set<InjectionPoint> injectionPoints;
    private Class<? extends T> proxyClass;
    private String passivationId;
    private InterceptorResolutionService.BeanInterceptorInfo interceptorInfo;
    private InterceptorDecoratorProxyFactory proxyFactory;
    private Map<Method, List<Interceptor<?>>> methodInterceptors;

    public AbstractProducer() {
        this(Collections.emptySet());
    }

    public AbstractProducer(Set<InjectionPoint> points) {
        this.injectionPoints = points;
    }

    public void defineInterceptorStack(Bean<T> bean, AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
        this.interceptorInfo = webBeansContext.getInterceptorResolutionService().calculateInterceptorInfo(bean.getTypes(), bean.getQualifiers(), annotatedType);
        this.proxyFactory = webBeansContext.getInterceptorDecoratorProxyFactory();
        if (bean instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)bean;
            this.passivationId = passivationCapable.getId();
        }
        this.methodInterceptors = new HashMap();
        for (Map.Entry<Method, InterceptorResolutionService.BusinessMethodInterceptorInfo> miEntry : this.interceptorInfo.getBusinessMethodsInfo().entrySet()) {
            Method interceptedMethod = miEntry.getKey();
            InterceptorResolutionService.BusinessMethodInterceptorInfo mii = miEntry.getValue();
            ArrayList activeInterceptors = new ArrayList();
            if (mii.getEjbInterceptors() != null) {
                Collections.addAll(activeInterceptors, mii.getEjbInterceptors());
            }
            if (mii.getCdiInterceptors() != null) {
                Collections.addAll(activeInterceptors, mii.getCdiInterceptors());
            }
            if (this.interceptorInfo.getSelfInterceptorBean() != null && interceptedMethod.getAnnotation(AroundInvoke.class) == null) {
                activeInterceptors.add(this.interceptorInfo.getSelfInterceptorBean());
            }
            if (activeInterceptors.size() > 0) {
                this.methodInterceptors.put(interceptedMethod, activeInterceptors);
                continue;
            }
            if (mii.getMethodDecorators() == null) continue;
            this.methodInterceptors.put(interceptedMethod, Collections.EMPTY_LIST);
        }
        this.defineLifecycleInterceptors(bean, annotatedType, webBeansContext);
        if (this.needsProxy()) {
            InterceptorDecoratorProxyFactory pf = webBeansContext.getInterceptorDecoratorProxyFactory();
            ClassLoader classLoader = webBeansContext.getApplicationBoundaryService().getBoundaryClassLoader(annotatedType.getJavaClass());
            Method[] businessMethods = this.methodInterceptors.keySet().toArray(new Method[this.methodInterceptors.size()]);
            Method[] nonInterceptedMethods = this.interceptorInfo.getNonInterceptedMethods().toArray(new Method[this.interceptorInfo.getNonInterceptedMethods().size()]);
            this.proxyClass = pf.createProxyClass(bean, classLoader, annotatedType.getJavaClass(), businessMethods, nonInterceptedMethods);
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public InterceptorResolutionService.BeanInterceptorInfo getInterceptorInfo() {
        return this.interceptorInfo;
    }

    /*
     * WARNING - void declaration
     */
    public T produce(CreationalContext<T> creationalContext) {
        CreationalContextImpl creationalContextImpl = (CreationalContextImpl)creationalContext;
        HashMap<Interceptor, Object> interceptorInstances = new HashMap<Interceptor, Object>();
        Contextual oldContextual = creationalContextImpl.getContextual();
        if (this.interceptorInfo != null) {
            for (Interceptor interceptor : this.interceptorInfo.getEjbInterceptors()) {
                creationalContextImpl.putContextual(interceptor);
                interceptorInstances.put(interceptor, interceptor.create(creationalContext));
            }
            for (Interceptor interceptor : this.interceptorInfo.getCdiInterceptors()) {
                creationalContextImpl.putContextual(interceptor);
                interceptorInstances.put(interceptor, interceptor.create(creationalContext));
            }
        }
        T instance = this.produce(interceptorInstances, creationalContextImpl);
        if (this.hasInterceptorInfo()) {
            void var6_10;
            if (this.interceptorInfo.getSelfInterceptorBean() != null) {
                interceptorInstances.put(this.interceptorInfo.getSelfInterceptorBean(), instance);
            }
            T t = instance;
            if (this.interceptorInfo.getDecorators() != null && !this.isDelegateInjection(creationalContextImpl)) {
                List<Decorator<?>> decorators = this.interceptorInfo.getDecorators();
                HashMap instances = new HashMap();
                for (int i = decorators.size(); i > 0; --i) {
                    Decorator<?> decorator = decorators.get(i - 1);
                    creationalContextImpl.putContextual(decorator);
                    creationalContextImpl.putDelegate(var6_10);
                    Object decoratorInstance = decorator.create(creationalContext);
                    instances.put(decorator, decoratorInstance);
                    T t2 = this.proxyFactory.createProxyInstance(this.proxyClass, instance, new DecoratorHandler(this.interceptorInfo, instances, i - 1, instance, this.passivationId));
                }
            }
            DefaultInterceptorHandler<void> interceptorHandler = new DefaultInterceptorHandler<void>((void)instance, var6_10, this.methodInterceptors, (Map<Interceptor<?>, ?>)interceptorInstances, this.passivationId);
            T proxyInstance = this.proxyFactory.createProxyInstance(this.proxyClass, instance, interceptorHandler);
            instance = proxyInstance;
            creationalContextImpl.putContextual(oldContextual);
        }
        return instance;
    }

    public void dispose(T instance) {
    }

    protected abstract T produce(Map<Interceptor<?>, ?> var1, CreationalContextImpl<T> var2);

    protected InterceptorDecoratorProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected Map<Method, List<Interceptor<?>>> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    protected boolean needsProxy() {
        return this.methodInterceptors.size() != 0;
    }

    protected boolean hasInterceptorInfo() {
        return this.interceptorInfo != null && this.proxyClass != null;
    }

    protected boolean isDelegateInjection(CreationalContextImpl<?> cc) {
        InjectionPoint ip = cc.getInjectionPoint();
        if (ip == null) {
            return false;
        }
        return ip.getAnnotated().isAnnotationPresent(Delegate.class);
    }

    protected T unwrapProxyInstance(T probableProxyInstance) {
        if (this.proxyFactory != null && probableProxyInstance instanceof OwbInterceptorProxy) {
            return InterceptorDecoratorProxyFactory.unwrapInstance(probableProxyInstance);
        }
        return probableProxyInstance;
    }

    protected void defineLifecycleInterceptors(Bean<T> bean, AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
    }
}

