/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSOutputStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.filter.DecodeOptions;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessOutputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadView;
import org.apache.pdfbox.io.RandomAccessStreamCache;

public class COSStream
extends COSDictionary
implements Closeable {
    private RandomAccess randomAccess;
    private RandomAccessStreamCache streamCache;
    private boolean closeStreamCache = false;
    private boolean isWriting;
    private RandomAccessReadView randomAccessReadView;
    private static final Log LOG = LogFactory.getLog(COSStream.class);

    public COSStream() {
        this((RandomAccessStreamCache)null);
    }

    public COSStream(RandomAccessStreamCache streamCache) {
        this.setInt(COSName.LENGTH, 0);
        this.streamCache = streamCache;
    }

    public COSStream(RandomAccessStreamCache streamCache, RandomAccessReadView randomAccessReadView) throws IOException {
        this(streamCache);
        this.randomAccessReadView = randomAccessReadView;
        this.setInt(COSName.LENGTH, (int)randomAccessReadView.length());
    }

    private void checkClosed() throws IOException {
        if (this.randomAccess != null && this.randomAccess.isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
    }

    private RandomAccessStreamCache getStreamCache() throws IOException {
        if (this.streamCache == null) {
            this.streamCache = IOUtils.createMemoryOnlyStreamCache().create();
            this.closeStreamCache = true;
        }
        return this.streamCache;
    }

    public InputStream createRawInputStream() throws IOException {
        this.checkClosed();
        if (this.isWriting) {
            throw new IllegalStateException("Cannot read while there is an open stream writer");
        }
        if (this.randomAccess == null) {
            if (this.randomAccessReadView != null) {
                this.randomAccessReadView.seek(0L);
                return new RandomAccessInputStream(this.randomAccessReadView);
            }
            throw new IOException("Create InputStream called without data being written before to stream.");
        }
        return new RandomAccessInputStream(this.randomAccess);
    }

    public COSInputStream createInputStream() throws IOException {
        return this.createInputStream(DecodeOptions.DEFAULT);
    }

    public COSInputStream createInputStream(DecodeOptions options) throws IOException {
        InputStream input = this.createRawInputStream();
        return COSInputStream.create(this.getFilterList(), this, input, options);
    }

    public RandomAccessRead createView() throws IOException {
        List<Filter> filterList = this.getFilterList();
        if (filterList.isEmpty()) {
            if (this.randomAccess == null && this.randomAccessReadView != null) {
                return new RandomAccessReadView(this.randomAccessReadView, 0L, this.randomAccessReadView.length());
            }
            return new RandomAccessReadBuffer(this.createRawInputStream());
        }
        return Filter.decode(this.createRawInputStream(), filterList, this, DecodeOptions.DEFAULT, null);
    }

    public OutputStream createOutputStream() throws IOException {
        return this.createOutputStream(null);
    }

    public OutputStream createOutputStream(COSBase filters) throws IOException {
        this.checkClosed();
        if (this.isWriting) {
            throw new IllegalStateException("Cannot have more than one open stream writer.");
        }
        if (filters != null) {
            this.setItem(COSName.FILTER, filters);
        }
        if (this.randomAccess != null) {
            this.randomAccess.clear();
        } else {
            this.randomAccess = this.getStreamCache().createBuffer();
        }
        RandomAccessOutputStream randomOut = new RandomAccessOutputStream(this.randomAccess);
        COSOutputStream cosOut = new COSOutputStream(this.getFilterList(), this, randomOut, this.getStreamCache());
        this.isWriting = true;
        return new FilterOutputStream(cosOut){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                COSStream.this.setInt(COSName.LENGTH, (int)COSStream.this.randomAccess.length());
                COSStream.this.isWriting = false;
            }
        };
    }

    public OutputStream createRawOutputStream() throws IOException {
        this.checkClosed();
        if (this.isWriting) {
            throw new IllegalStateException("Cannot have more than one open stream writer.");
        }
        if (this.randomAccess != null) {
            this.randomAccess.clear();
        } else {
            this.randomAccess = this.getStreamCache().createBuffer();
        }
        RandomAccessOutputStream out = new RandomAccessOutputStream(this.randomAccess);
        this.isWriting = true;
        return new FilterOutputStream(out){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                COSStream.this.setInt(COSName.LENGTH, (int)COSStream.this.randomAccess.length());
                COSStream.this.isWriting = false;
            }
        };
    }

    private List<Filter> getFilterList() throws IOException {
        ArrayList<Filter> filterList;
        COSBase filters = this.getFilters();
        if (filters instanceof COSName) {
            filterList = new ArrayList<Filter>(1);
            filterList.add(FilterFactory.INSTANCE.getFilter((COSName)filters));
        } else if (filters instanceof COSArray) {
            COSArray filterArray = (COSArray)filters;
            filterList = new ArrayList(filterArray.size());
            for (int i = 0; i < filterArray.size(); ++i) {
                COSBase base = filterArray.get(i);
                if (!(base instanceof COSName)) {
                    throw new IOException("Forbidden type in filter array: " + (base == null ? "null" : base.getClass().getName()));
                }
                filterList.add(FilterFactory.INSTANCE.getFilter((COSName)base));
            }
        } else {
            filterList = new ArrayList();
        }
        return filterList;
    }

    public long getLength() {
        if (this.isWriting) {
            throw new IllegalStateException("There is an open OutputStream associated with this COSStream. It must be closed before querying the length of this COSStream.");
        }
        return this.getInt(COSName.LENGTH, 0);
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toTextString() {
        try (COSInputStream input = this.createInputStream();){
            byte[] array = IOUtils.toByteArray(input);
            COSString string2 = new COSString(array);
            String string = string2.getString();
            return string;
        }
        catch (IOException e) {
            LOG.debug("An exception occurred trying to get the content - returning empty string instead", e);
            return "";
        }
    }

    @Override
    public void accept(ICOSVisitor visitor) throws IOException {
        visitor.visitFromStream(this);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.closeStreamCache && this.streamCache != null) {
                this.streamCache.close();
                this.streamCache = null;
            }
        }
        finally {
            try {
                if (this.randomAccess != null) {
                    this.randomAccess.close();
                    this.randomAccess = null;
                }
            }
            finally {
                if (this.randomAccessReadView != null) {
                    this.randomAccessReadView.close();
                    this.randomAccessReadView = null;
                }
            }
        }
    }

    public boolean hasData() {
        return this.randomAccess != null || this.randomAccessReadView != null;
    }
}

