/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.ReaderInterceptor;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;

public class ReaderConfigurationData<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(name="topicNames", required=true, value="Topic name")
    private Set<String> topicNames = new HashSet<String>();
    @JsonIgnore
    private MessageId startMessageId;
    @JsonIgnore
    private long startMessageFromRollbackDurationInSec;
    @ApiModelProperty(name="receiverQueueSize", value="Size of a consumer's receiver queue.\n\nFor example, the number of messages that can be accumulated by a consumer before an application calls `Receive`.\n\nA value higher than the default value increases consumer throughput, though at the expense of more memory utilization.")
    private int receiverQueueSize = 1000;
    @ApiModelProperty(name="readerListener", value="A listener that is called for message received.")
    private ReaderListener<T> readerListener;
    @ApiModelProperty(name="readerName", value="Reader name")
    private String readerName = null;
    @ApiModelProperty(name="subscriptionRolePrefix", value="Prefix of subscription role.")
    private String subscriptionRolePrefix = null;
    @ApiModelProperty(name="subscriptionName", value="Subscription name")
    private String subscriptionName = null;
    @ApiModelProperty(name="cryptoKeyReader", value="Interface that abstracts the access to a key store.")
    private CryptoKeyReader cryptoKeyReader = null;
    @ApiModelProperty(name="cryptoFailureAction", value="Consumer should take action when it receives a message that can not be decrypted.\n* **FAIL**: this is the default option to fail messages until crypto succeeds.\n* **DISCARD**: silently acknowledge and not deliver message to an application.\n* **CONSUME**: deliver encrypted messages to applications. It is the application's responsibility to decrypt the message.\n\nThe message decompression fails.\n\nIf messages contain batch messages, a client is not be able to retrieve individual messages in batch.\n\nDelivered encrypted message contains {@link EncryptionContext} which contains encryption and compression information in it using which application can decrypt consumed message payload.")
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    @ApiModelProperty(name="readCompacted", value="If enabling `readCompacted`, a consumer reads messages from a compacted topic rather than a full message backlog of a topic.\n\nA consumer only sees the latest value for each key in the compacted topic, up until reaching the point in the topic message when compacting backlog. Beyond that point, send messages as normal.\n\n`readCompacted` can only be enabled on subscriptions to persistent topics, which have a single active consumer (for example, failure or exclusive subscriptions).\n\nAttempting to enable it on subscriptions to non-persistent topics or on shared subscriptions leads to a subscription call throwing a `PulsarClientException`.")
    private boolean readCompacted = false;
    @ApiModelProperty(name="resetIncludeHead", value="If set to true, the first message to be returned is the one specified by `messageId`.\n\nIf set to false, the first message to be returned is the one next to the message specified by `messageId`.")
    private boolean resetIncludeHead = false;
    private List<Range> keyHashRanges;
    private boolean poolMessages = false;
    private boolean autoUpdatePartitions = true;
    private long autoUpdatePartitionsIntervalSeconds = 60L;
    private transient List<ReaderInterceptor<T>> readerInterceptorList;
    private int maxPendingChunkedMessage = 10;
    private boolean autoAckOldestChunkedMessageOnQueueFull = false;
    private long expireTimeOfIncompleteChunkedMessageMillis = TimeUnit.MINUTES.toMillis(1L);
    private SubscriptionMode subscriptionMode = SubscriptionMode.NonDurable;
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;

    @JsonIgnore
    public String getTopicName() {
        if (this.topicNames.size() > 1) {
            throw new IllegalArgumentException("topicNames needs to be = 1");
        }
        return this.topicNames.iterator().next();
    }

    @JsonIgnore
    public void setTopicName(String topicNames) {
        this.topicNames.clear();
        this.topicNames.add(topicNames);
    }

    public ReaderConfigurationData<T> clone() {
        try {
            ReaderConfigurationData clone = (ReaderConfigurationData)super.clone();
            clone.setTopicNames(new HashSet<String>(clone.getTopicNames()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ReaderConfigurationData");
        }
    }

    @Generated
    public ReaderConfigurationData() {
    }

    @Generated
    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    @Generated
    public MessageId getStartMessageId() {
        return this.startMessageId;
    }

    @Generated
    public long getStartMessageFromRollbackDurationInSec() {
        return this.startMessageFromRollbackDurationInSec;
    }

    @Generated
    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    @Generated
    public ReaderListener<T> getReaderListener() {
        return this.readerListener;
    }

    @Generated
    public String getReaderName() {
        return this.readerName;
    }

    @Generated
    public String getSubscriptionRolePrefix() {
        return this.subscriptionRolePrefix;
    }

    @Generated
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    @Generated
    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    @Generated
    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    @Generated
    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    @Generated
    public boolean isResetIncludeHead() {
        return this.resetIncludeHead;
    }

    @Generated
    public List<Range> getKeyHashRanges() {
        return this.keyHashRanges;
    }

    @Generated
    public boolean isPoolMessages() {
        return this.poolMessages;
    }

    @Generated
    public boolean isAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    @Generated
    public long getAutoUpdatePartitionsIntervalSeconds() {
        return this.autoUpdatePartitionsIntervalSeconds;
    }

    @Generated
    public List<ReaderInterceptor<T>> getReaderInterceptorList() {
        return this.readerInterceptorList;
    }

    @Generated
    public int getMaxPendingChunkedMessage() {
        return this.maxPendingChunkedMessage;
    }

    @Generated
    public boolean isAutoAckOldestChunkedMessageOnQueueFull() {
        return this.autoAckOldestChunkedMessageOnQueueFull;
    }

    @Generated
    public long getExpireTimeOfIncompleteChunkedMessageMillis() {
        return this.expireTimeOfIncompleteChunkedMessageMillis;
    }

    @Generated
    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    @Generated
    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.subscriptionInitialPosition;
    }

    @Generated
    public void setTopicNames(Set<String> topicNames) {
        this.topicNames = topicNames;
    }

    @Generated
    public void setStartMessageId(MessageId startMessageId) {
        this.startMessageId = startMessageId;
    }

    @Generated
    public void setStartMessageFromRollbackDurationInSec(long startMessageFromRollbackDurationInSec) {
        this.startMessageFromRollbackDurationInSec = startMessageFromRollbackDurationInSec;
    }

    @Generated
    public void setReceiverQueueSize(int receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    @Generated
    public void setReaderListener(ReaderListener<T> readerListener) {
        this.readerListener = readerListener;
    }

    @Generated
    public void setReaderName(String readerName) {
        this.readerName = readerName;
    }

    @Generated
    public void setSubscriptionRolePrefix(String subscriptionRolePrefix) {
        this.subscriptionRolePrefix = subscriptionRolePrefix;
    }

    @Generated
    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @Generated
    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    @Generated
    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    @Generated
    public void setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    @Generated
    public void setResetIncludeHead(boolean resetIncludeHead) {
        this.resetIncludeHead = resetIncludeHead;
    }

    @Generated
    public void setKeyHashRanges(List<Range> keyHashRanges) {
        this.keyHashRanges = keyHashRanges;
    }

    @Generated
    public void setPoolMessages(boolean poolMessages) {
        this.poolMessages = poolMessages;
    }

    @Generated
    public void setAutoUpdatePartitions(boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    @Generated
    public void setAutoUpdatePartitionsIntervalSeconds(long autoUpdatePartitionsIntervalSeconds) {
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
    }

    @Generated
    public void setReaderInterceptorList(List<ReaderInterceptor<T>> readerInterceptorList) {
        this.readerInterceptorList = readerInterceptorList;
    }

    @Generated
    public void setMaxPendingChunkedMessage(int maxPendingChunkedMessage) {
        this.maxPendingChunkedMessage = maxPendingChunkedMessage;
    }

    @Generated
    public void setAutoAckOldestChunkedMessageOnQueueFull(boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
    }

    @Generated
    public void setExpireTimeOfIncompleteChunkedMessageMillis(long expireTimeOfIncompleteChunkedMessageMillis) {
        this.expireTimeOfIncompleteChunkedMessageMillis = expireTimeOfIncompleteChunkedMessageMillis;
    }

    @Generated
    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    @Generated
    public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReaderConfigurationData)) {
            return false;
        }
        ReaderConfigurationData other = (ReaderConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartMessageFromRollbackDurationInSec() != other.getStartMessageFromRollbackDurationInSec()) {
            return false;
        }
        if (this.getReceiverQueueSize() != other.getReceiverQueueSize()) {
            return false;
        }
        if (this.isReadCompacted() != other.isReadCompacted()) {
            return false;
        }
        if (this.isResetIncludeHead() != other.isResetIncludeHead()) {
            return false;
        }
        if (this.isPoolMessages() != other.isPoolMessages()) {
            return false;
        }
        if (this.isAutoUpdatePartitions() != other.isAutoUpdatePartitions()) {
            return false;
        }
        if (this.getAutoUpdatePartitionsIntervalSeconds() != other.getAutoUpdatePartitionsIntervalSeconds()) {
            return false;
        }
        if (this.getMaxPendingChunkedMessage() != other.getMaxPendingChunkedMessage()) {
            return false;
        }
        if (this.isAutoAckOldestChunkedMessageOnQueueFull() != other.isAutoAckOldestChunkedMessageOnQueueFull()) {
            return false;
        }
        if (this.getExpireTimeOfIncompleteChunkedMessageMillis() != other.getExpireTimeOfIncompleteChunkedMessageMillis()) {
            return false;
        }
        Set<String> this$topicNames = this.getTopicNames();
        Set<String> other$topicNames = other.getTopicNames();
        if (this$topicNames == null ? other$topicNames != null : !((Object)this$topicNames).equals(other$topicNames)) {
            return false;
        }
        MessageId this$startMessageId = this.getStartMessageId();
        MessageId other$startMessageId = other.getStartMessageId();
        if (this$startMessageId == null ? other$startMessageId != null : !this$startMessageId.equals(other$startMessageId)) {
            return false;
        }
        ReaderListener<T> this$readerListener = this.getReaderListener();
        ReaderListener<T> other$readerListener = other.getReaderListener();
        if (this$readerListener == null ? other$readerListener != null : !this$readerListener.equals(other$readerListener)) {
            return false;
        }
        String this$readerName = this.getReaderName();
        String other$readerName = other.getReaderName();
        if (this$readerName == null ? other$readerName != null : !this$readerName.equals(other$readerName)) {
            return false;
        }
        String this$subscriptionRolePrefix = this.getSubscriptionRolePrefix();
        String other$subscriptionRolePrefix = other.getSubscriptionRolePrefix();
        if (this$subscriptionRolePrefix == null ? other$subscriptionRolePrefix != null : !this$subscriptionRolePrefix.equals(other$subscriptionRolePrefix)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        ConsumerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ConsumerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        if (this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !this$cryptoFailureAction.equals(other$cryptoFailureAction)) {
            return false;
        }
        List<Range> this$keyHashRanges = this.getKeyHashRanges();
        List<Range> other$keyHashRanges = other.getKeyHashRanges();
        if (this$keyHashRanges == null ? other$keyHashRanges != null : !((Object)this$keyHashRanges).equals(other$keyHashRanges)) {
            return false;
        }
        SubscriptionMode this$subscriptionMode = this.getSubscriptionMode();
        SubscriptionMode other$subscriptionMode = other.getSubscriptionMode();
        if (this$subscriptionMode == null ? other$subscriptionMode != null : !this$subscriptionMode.equals(other$subscriptionMode)) {
            return false;
        }
        SubscriptionInitialPosition this$subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        SubscriptionInitialPosition other$subscriptionInitialPosition = other.getSubscriptionInitialPosition();
        return !(this$subscriptionInitialPosition == null ? other$subscriptionInitialPosition != null : !this$subscriptionInitialPosition.equals(other$subscriptionInitialPosition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReaderConfigurationData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startMessageFromRollbackDurationInSec = this.getStartMessageFromRollbackDurationInSec();
        result = result * 59 + (int)($startMessageFromRollbackDurationInSec >>> 32 ^ $startMessageFromRollbackDurationInSec);
        result = result * 59 + this.getReceiverQueueSize();
        result = result * 59 + (this.isReadCompacted() ? 79 : 97);
        result = result * 59 + (this.isResetIncludeHead() ? 79 : 97);
        result = result * 59 + (this.isPoolMessages() ? 79 : 97);
        result = result * 59 + (this.isAutoUpdatePartitions() ? 79 : 97);
        long $autoUpdatePartitionsIntervalSeconds = this.getAutoUpdatePartitionsIntervalSeconds();
        result = result * 59 + (int)($autoUpdatePartitionsIntervalSeconds >>> 32 ^ $autoUpdatePartitionsIntervalSeconds);
        result = result * 59 + this.getMaxPendingChunkedMessage();
        result = result * 59 + (this.isAutoAckOldestChunkedMessageOnQueueFull() ? 79 : 97);
        long $expireTimeOfIncompleteChunkedMessageMillis = this.getExpireTimeOfIncompleteChunkedMessageMillis();
        result = result * 59 + (int)($expireTimeOfIncompleteChunkedMessageMillis >>> 32 ^ $expireTimeOfIncompleteChunkedMessageMillis);
        Set<String> $topicNames = this.getTopicNames();
        result = result * 59 + ($topicNames == null ? 43 : ((Object)$topicNames).hashCode());
        MessageId $startMessageId = this.getStartMessageId();
        result = result * 59 + ($startMessageId == null ? 43 : $startMessageId.hashCode());
        ReaderListener<T> $readerListener = this.getReaderListener();
        result = result * 59 + ($readerListener == null ? 43 : $readerListener.hashCode());
        String $readerName = this.getReaderName();
        result = result * 59 + ($readerName == null ? 43 : $readerName.hashCode());
        String $subscriptionRolePrefix = this.getSubscriptionRolePrefix();
        result = result * 59 + ($subscriptionRolePrefix == null ? 43 : $subscriptionRolePrefix.hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        ConsumerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : $cryptoFailureAction.hashCode());
        List<Range> $keyHashRanges = this.getKeyHashRanges();
        result = result * 59 + ($keyHashRanges == null ? 43 : ((Object)$keyHashRanges).hashCode());
        SubscriptionMode $subscriptionMode = this.getSubscriptionMode();
        result = result * 59 + ($subscriptionMode == null ? 43 : $subscriptionMode.hashCode());
        SubscriptionInitialPosition $subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        result = result * 59 + ($subscriptionInitialPosition == null ? 43 : $subscriptionInitialPosition.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReaderConfigurationData(topicNames=" + this.getTopicNames() + ", startMessageId=" + this.getStartMessageId() + ", startMessageFromRollbackDurationInSec=" + this.getStartMessageFromRollbackDurationInSec() + ", receiverQueueSize=" + this.getReceiverQueueSize() + ", readerListener=" + this.getReaderListener() + ", readerName=" + this.getReaderName() + ", subscriptionRolePrefix=" + this.getSubscriptionRolePrefix() + ", subscriptionName=" + this.getSubscriptionName() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", cryptoFailureAction=" + this.getCryptoFailureAction() + ", readCompacted=" + this.isReadCompacted() + ", resetIncludeHead=" + this.isResetIncludeHead() + ", keyHashRanges=" + this.getKeyHashRanges() + ", poolMessages=" + this.isPoolMessages() + ", autoUpdatePartitions=" + this.isAutoUpdatePartitions() + ", autoUpdatePartitionsIntervalSeconds=" + this.getAutoUpdatePartitionsIntervalSeconds() + ", readerInterceptorList=" + this.getReaderInterceptorList() + ", maxPendingChunkedMessage=" + this.getMaxPendingChunkedMessage() + ", autoAckOldestChunkedMessageOnQueueFull=" + this.isAutoAckOldestChunkedMessageOnQueueFull() + ", expireTimeOfIncompleteChunkedMessageMillis=" + this.getExpireTimeOfIncompleteChunkedMessageMillis() + ", subscriptionMode=" + this.getSubscriptionMode() + ", subscriptionInitialPosition=" + this.getSubscriptionInitialPosition() + ")";
    }
}

