/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class DoubleDecoder
extends AbstractDecoder
implements Decoder.Text<Double> {
    public static final DoubleDecoder INSTANCE = new DoubleDecoder();

    public Double decode(String s) throws DecodeException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse double", (Throwable)e);
        }
    }

    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

