/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.container.logback;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.slf4j.LoggerFactory;

public class BrokerLogbackConfigurator {
    private static final InternalLogger LOG = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final Set<String> CONFIGURED_BROKER_LIST = new HashSet<String>();
    public static final String ROCKETMQ_LOGS = "rocketmqlogs";
    public static final String ROCKETMQ_PREFIX = "Rocketmq";
    public static final String SUFFIX_CONSOLE = "Console";
    public static final String SUFFIX_APPENDER = "Appender";
    public static final String SUFFIX_INNER_APPENDER = "_inner";

    public static void doConfigure(BrokerIdentity brokerIdentity) {
        if (!CONFIGURED_BROKER_LIST.contains(brokerIdentity.getCanonicalName())) {
            try {
                LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                for (Logger tempLogger : lc.getLoggerList()) {
                    String loggerName = tempLogger.getName();
                    if (!loggerName.startsWith(ROCKETMQ_PREFIX) || loggerName.endsWith(SUFFIX_CONSOLE) || loggerName.equals("RocketmqAccount") || loggerName.equals("RocketmqCommercial") || loggerName.equals("RocketmqConsumerStats")) continue;
                    Logger logger = lc.getLogger(brokerIdentity.getLoggerIdentifier() + loggerName);
                    logger.setAdditive(tempLogger.isAdditive());
                    logger.setLevel(tempLogger.getLevel());
                    String appenderName = loggerName + SUFFIX_APPENDER;
                    Appender tempAppender = tempLogger.getAppender(appenderName);
                    if (tempAppender instanceof AsyncAppender) {
                        AsyncAppender tempAsyncAppender = (AsyncAppender)tempAppender;
                        AsyncAppender asyncAppender = new AsyncAppender();
                        asyncAppender.setName(brokerIdentity.getLoggerIdentifier() + appenderName);
                        asyncAppender.setContext(tempAsyncAppender.getContext());
                        String innerAppenderName = appenderName + SUFFIX_INNER_APPENDER;
                        Appender tempInnerAppender = tempAsyncAppender.getAppender(innerAppenderName);
                        if (!(tempInnerAppender instanceof RollingFileAppender)) continue;
                        asyncAppender.addAppender(BrokerLogbackConfigurator.configureRollingFileAppender((RollingFileAppender<ILoggingEvent>)((RollingFileAppender)tempInnerAppender), brokerIdentity, innerAppenderName));
                        asyncAppender.start();
                        logger.addAppender((Appender)asyncAppender);
                        continue;
                    }
                    if (!(tempAppender instanceof RollingFileAppender)) continue;
                    logger.addAppender(BrokerLogbackConfigurator.configureRollingFileAppender((RollingFileAppender<ILoggingEvent>)((RollingFileAppender)tempAppender), brokerIdentity, appenderName));
                }
            }
            catch (Exception e) {
                LOG.error("Configure logback for broker {} failed, will use default broker log config instead. {}", (Object)brokerIdentity.getCanonicalName(), (Object)e);
                return;
            }
            CONFIGURED_BROKER_LIST.add(brokerIdentity.getCanonicalName());
        }
    }

    private static RollingFileAppender<ILoggingEvent> configureRollingFileAppender(RollingFileAppender<ILoggingEvent> tempRollingFileAppender, BrokerIdentity brokerIdentity, String appenderName) throws NoSuchFieldException, IllegalAccessException {
        Encoder tempEncoder;
        TimeBasedRollingPolicy rollingPolicy;
        TimeBasedRollingPolicy tempRollingPolicy;
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setName(brokerIdentity.getLoggerIdentifier() + appenderName);
        rollingFileAppender.setFile(tempRollingFileAppender.getFile().replaceAll(ROCKETMQ_LOGS, brokerIdentity.getCanonicalName() + "_" + ROCKETMQ_LOGS));
        rollingFileAppender.setAppend(true);
        rollingFileAppender.setPrudent(tempRollingFileAppender.isPrudent());
        RollingPolicy originalRollingPolicy = tempRollingFileAppender.getRollingPolicy();
        if (originalRollingPolicy instanceof TimeBasedRollingPolicy) {
            tempRollingPolicy = (TimeBasedRollingPolicy)originalRollingPolicy;
            rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext(tempRollingPolicy.getContext());
            rollingPolicy.setFileNamePattern(tempRollingPolicy.getFileNamePattern());
            SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
            sizeAndTimeBasedFNATP.setContext(tempRollingPolicy.getContext());
            TimeBasedFileNamingAndTriggeringPolicy timeBasedFileNamingAndTriggeringPolicy = tempRollingPolicy.getTimeBasedFileNamingAndTriggeringPolicy();
            if (timeBasedFileNamingAndTriggeringPolicy instanceof SizeAndTimeBasedFNATP) {
                SizeAndTimeBasedFNATP originalSizeAndTimeBasedFNATP = (SizeAndTimeBasedFNATP)timeBasedFileNamingAndTriggeringPolicy;
                Field field = originalSizeAndTimeBasedFNATP.getClass().getDeclaredField("maxFileSize");
                field.setAccessible(true);
                sizeAndTimeBasedFNATP.setMaxFileSize((FileSize)field.get(originalSizeAndTimeBasedFNATP));
                sizeAndTimeBasedFNATP.setTimeBasedRollingPolicy(rollingPolicy);
            }
            rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)sizeAndTimeBasedFNATP);
            rollingPolicy.setMaxHistory(tempRollingPolicy.getMaxHistory());
            rollingPolicy.setParent((FileAppender)rollingFileAppender);
            rollingPolicy.start();
            rollingFileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        } else if (originalRollingPolicy instanceof FixedWindowRollingPolicy) {
            tempRollingPolicy = (FixedWindowRollingPolicy)originalRollingPolicy;
            rollingPolicy = new FixedWindowRollingPolicy();
            rollingPolicy.setContext(tempRollingPolicy.getContext());
            rollingPolicy.setFileNamePattern(tempRollingPolicy.getFileNamePattern().replaceAll(ROCKETMQ_LOGS, brokerIdentity.getCanonicalName() + "_" + ROCKETMQ_LOGS));
            rollingPolicy.setMaxIndex(tempRollingPolicy.getMaxIndex());
            rollingPolicy.setMinIndex(tempRollingPolicy.getMinIndex());
            rollingPolicy.setParent((FileAppender)rollingFileAppender);
            rollingPolicy.start();
            rollingFileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        }
        if (tempRollingFileAppender.getTriggeringPolicy() instanceof SizeBasedTriggeringPolicy) {
            SizeBasedTriggeringPolicy tempTriggerPolicy = (SizeBasedTriggeringPolicy)tempRollingFileAppender.getTriggeringPolicy();
            SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy();
            triggerPolicy.setContext(tempTriggerPolicy.getContext());
            Field field = triggerPolicy.getClass().getDeclaredField("maxFileSize");
            field.setAccessible(true);
            triggerPolicy.setMaxFileSize((FileSize)field.get(triggerPolicy));
            triggerPolicy.start();
            rollingFileAppender.setTriggeringPolicy((TriggeringPolicy)triggerPolicy);
        }
        if ((tempEncoder = tempRollingFileAppender.getEncoder()) instanceof PatternLayoutEncoder) {
            PatternLayoutEncoder tempPatternLayoutEncoder = (PatternLayoutEncoder)tempEncoder;
            PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
            patternLayoutEncoder.setContext(tempPatternLayoutEncoder.getContext());
            patternLayoutEncoder.setPattern(tempPatternLayoutEncoder.getPattern());
            patternLayoutEncoder.setCharset(tempPatternLayoutEncoder.getCharset());
            patternLayoutEncoder.start();
            rollingFileAppender.setEncoder((Encoder)patternLayoutEncoder);
        }
        rollingFileAppender.setContext(tempRollingFileAppender.getContext());
        rollingFileAppender.start();
        return rollingFileAppender;
    }
}

