/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.tracemessage;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.io.UnsupportedEncodingException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.hook.EndTransactionHook;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.client.trace.hook.EndTransactionOpenTracingHookImpl;
import org.apache.rocketmq.client.trace.hook.SendMessageOpenTracingHookImpl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;

public class OpenTracingTransactionProducer {
    public static final String PRODUCER_GROUP = "please_rename_unique_group_name";
    public static final String DEFAULT_NAMESRVADDR = "127.0.0.1:9876";
    public static final String TOPIC = "TopicTest";
    public static final String TAG = "Tag";
    public static final String KEY = "KEY";
    public static final int MESSAGE_COUNT = 100000;

    public static void main(String[] args) throws MQClientException, InterruptedException {
        Tracer tracer = OpenTracingTransactionProducer.initTracer();
        TransactionMQProducer producer = new TransactionMQProducer(PRODUCER_GROUP);
        producer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new SendMessageOpenTracingHookImpl(tracer));
        producer.getDefaultMQProducerImpl().registerEndTransactionHook((EndTransactionHook)new EndTransactionOpenTracingHookImpl(tracer));
        producer.setTransactionListener(new TransactionListener(){

            public LocalTransactionState executeLocalTransaction(Message msg, Object arg) {
                return LocalTransactionState.COMMIT_MESSAGE;
            }

            public LocalTransactionState checkLocalTransaction(MessageExt msg) {
                return LocalTransactionState.COMMIT_MESSAGE;
            }
        });
        producer.start();
        try {
            Message msg = new Message(TOPIC, TAG, KEY, "Hello RocketMQ".getBytes("UTF-8"));
            TransactionSendResult sendResult = producer.sendMessageInTransaction(msg, null);
            System.out.printf("%s%n", sendResult);
        }
        catch (UnsupportedEncodingException | MQClientException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 100000; ++i) {
            Thread.sleep(1000L);
        }
        producer.shutdown();
    }

    private static Tracer initTracer() {
        Configuration.SamplerConfiguration samplerConfig = Configuration.SamplerConfiguration.fromEnv().withType("const").withParam((Number)1);
        Configuration.ReporterConfiguration reporterConfig = Configuration.ReporterConfiguration.fromEnv().withLogSpans(Boolean.valueOf(true));
        Configuration config = new Configuration("rocketmq").withSampler(samplerConfig).withReporter(reporterConfig);
        GlobalTracer.registerIfAbsent((Tracer)config.getTracer());
        return config.getTracer();
    }
}

