/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger;

import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.utils.IOUtils;
import io.openmessaging.storage.dledger.utils.PreConditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberState {
    public static final String TERM_PERSIST_FILE = "currterm";
    public static final String TERM_PERSIST_KEY_TERM = "currTerm";
    public static final String TERM_PERSIST_KEY_VOTE_FOR = "voteLeader";
    public static Logger logger = LoggerFactory.getLogger(MemberState.class);
    public final DLedgerConfig dLedgerConfig;
    private final ReentrantLock defaultLock = new ReentrantLock();
    private final String group;
    private final String selfId;
    private final String peers;
    private volatile Role role = Role.CANDIDATE;
    private volatile String leaderId;
    private volatile long currTerm = 0L;
    private volatile String currVoteFor;
    private volatile long ledgerEndIndex = -1L;
    private volatile long ledgerEndTerm = -1L;
    private long knownMaxTermInGroup = -1L;
    private Map<String, String> peerMap = new HashMap<String, String>();
    private Map<String, Boolean> peersLiveTable = new ConcurrentHashMap<String, Boolean>();
    private volatile String transferee;
    private volatile long termToTakeLeadership = -1L;

    public MemberState(DLedgerConfig config) {
        this.group = config.getGroup();
        this.selfId = config.getSelfId();
        this.peers = config.getPeers();
        for (String peerInfo : this.peers.split(";")) {
            String peerSelfId = peerInfo.split("-")[0];
            String peerAddress = peerInfo.substring(peerSelfId.length() + 1);
            this.peerMap.put(peerSelfId, peerAddress);
        }
        this.dLedgerConfig = config;
        this.loadTerm();
    }

    private void loadTerm() {
        try {
            String data = IOUtils.file2String(this.dLedgerConfig.getDefaultPath() + File.separator + TERM_PERSIST_FILE);
            Properties properties = IOUtils.string2Properties(data);
            if (properties == null) {
                return;
            }
            if (properties.containsKey(TERM_PERSIST_KEY_TERM)) {
                this.currTerm = Long.valueOf(String.valueOf(properties.get(TERM_PERSIST_KEY_TERM)));
            }
            if (properties.containsKey(TERM_PERSIST_KEY_VOTE_FOR)) {
                this.currVoteFor = String.valueOf(properties.get(TERM_PERSIST_KEY_VOTE_FOR));
                if (this.currVoteFor.length() == 0) {
                    this.currVoteFor = null;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Load last term failed", t);
        }
    }

    private void persistTerm() {
        try {
            Properties properties = new Properties();
            properties.put(TERM_PERSIST_KEY_TERM, (Object)this.currTerm);
            properties.put(TERM_PERSIST_KEY_VOTE_FOR, this.currVoteFor == null ? "" : this.currVoteFor);
            String data = IOUtils.properties2String(properties);
            IOUtils.string2File(data, this.dLedgerConfig.getDefaultPath() + File.separator + TERM_PERSIST_FILE);
        }
        catch (Throwable t) {
            logger.error("Persist curr term failed", t);
        }
    }

    public long currTerm() {
        return this.currTerm;
    }

    public String currVoteFor() {
        return this.currVoteFor;
    }

    public synchronized void setCurrVoteFor(String currVoteFor) {
        this.currVoteFor = currVoteFor;
        this.persistTerm();
    }

    public synchronized long nextTerm() {
        PreConditions.check(this.role == Role.CANDIDATE, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "%s != %s", new Object[]{this.role, Role.CANDIDATE});
        this.currTerm = this.knownMaxTermInGroup > this.currTerm ? this.knownMaxTermInGroup : ++this.currTerm;
        this.currVoteFor = null;
        this.persistTerm();
        return this.currTerm;
    }

    public synchronized void changeToLeader(long term) {
        PreConditions.check(this.currTerm == term, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "%d != %d", this.currTerm, term);
        this.role = Role.LEADER;
        this.leaderId = this.selfId;
        this.peersLiveTable.clear();
    }

    public synchronized void changeToFollower(long term, String leaderId) {
        PreConditions.check(this.currTerm == term, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "%d != %d", this.currTerm, term);
        this.role = Role.FOLLOWER;
        this.leaderId = leaderId;
        this.transferee = null;
    }

    public synchronized void changeToCandidate(long term) {
        assert (term >= this.currTerm);
        PreConditions.check(term >= this.currTerm, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "should %d >= %d", term, this.currTerm);
        if (term > this.knownMaxTermInGroup) {
            this.knownMaxTermInGroup = term;
        }
        this.role = Role.CANDIDATE;
        this.leaderId = null;
        this.transferee = null;
    }

    public String getTransferee() {
        return this.transferee;
    }

    public void setTransferee(String transferee) {
        PreConditions.check(this.role == Role.LEADER, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "%s is not leader", this.selfId);
        this.transferee = transferee;
    }

    public long getTermToTakeLeadership() {
        return this.termToTakeLeadership;
    }

    public void setTermToTakeLeadership(long termToTakeLeadership) {
        this.termToTakeLeadership = termToTakeLeadership;
    }

    public String getSelfId() {
        return this.selfId;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public String getGroup() {
        return this.group;
    }

    public String getSelfAddr() {
        return this.peerMap.get(this.selfId);
    }

    public String getLeaderAddr() {
        return this.peerMap.get(this.leaderId);
    }

    public String getPeerAddr(String peerId) {
        return this.peerMap.get(peerId);
    }

    public boolean isLeader() {
        return this.role == Role.LEADER;
    }

    public boolean isFollower() {
        return this.role == Role.FOLLOWER;
    }

    public boolean isCandidate() {
        return this.role == Role.CANDIDATE;
    }

    public boolean isQuorum(int num) {
        return num >= this.peerSize() / 2 + 1;
    }

    public int peerSize() {
        return this.peerMap.size();
    }

    public boolean isPeerMember(String id) {
        return id != null && this.peerMap.containsKey(id);
    }

    public Map<String, String> getPeerMap() {
        return this.peerMap;
    }

    public Map<String, Boolean> getPeersLiveTable() {
        return this.peersLiveTable;
    }

    public void setCurrTermForTest(long term) {
        PreConditions.check(term >= this.currTerm, DLedgerResponseCode.ILLEGAL_MEMBER_STATE);
        this.currTerm = term;
    }

    public Role getRole() {
        return this.role;
    }

    public ReentrantLock getDefaultLock() {
        return this.defaultLock;
    }

    public void updateLedgerIndexAndTerm(long index, long term) {
        this.ledgerEndIndex = index;
        this.ledgerEndTerm = term;
    }

    public long getLedgerEndIndex() {
        return this.ledgerEndIndex;
    }

    public long getLedgerEndTerm() {
        return this.ledgerEndTerm;
    }

    public static enum Role {
        UNKNOWN,
        CANDIDATE,
        LEADER,
        FOLLOWER;

    }
}

