/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.collection;

import com.conversantmedia.util.collection.Stack;

public class FixedStack<N>
implements Stack<N> {
    private final int size;
    private final int mask;
    private final N[] stack;
    private int stackTop;

    public FixedStack(int size) {
        int stackSize;
        for (stackSize = 1; stackSize < size; stackSize <<= 1) {
        }
        this.size = stackSize;
        this.mask = this.size - 1;
        this.stack = new Object[stackSize];
        this.stackTop = 0;
    }

    @Override
    public boolean push(N n) {
        if (this.stackTop < this.size) {
            this.stack[this.stackTop++ & this.mask] = n;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(N n) {
        for (int i = 0; i < this.stackTop; ++i) {
            if (!this.stack[i].equals(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public N peek() {
        return this.stack[this.stackTop - 1 & this.mask];
    }

    @Override
    public N pop() {
        try {
            N n = this.stack[--this.stackTop & this.mask];
            return n;
        }
        finally {
            this.stack[this.stackTop & this.mask] = null;
        }
    }

    @Override
    public int size() {
        return this.stackTop;
    }

    @Override
    public int remainingCapacity() {
        return this.size - this.stackTop;
    }

    @Override
    public boolean isEmpty() {
        return this.stackTop == 0;
    }

    @Override
    public void clear() {
        this.stackTop = 0;
    }
}

