/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv;

import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.future.FutureTaskExt;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.namesrv.kvconfig.KVConfigManager;
import org.apache.rocketmq.namesrv.processor.ClientRequestProcessor;
import org.apache.rocketmq.namesrv.processor.ClusterTestRequestProcessor;
import org.apache.rocketmq.namesrv.processor.DefaultRequestProcessor;
import org.apache.rocketmq.namesrv.route.ZoneRouteRPCHook;
import org.apache.rocketmq.namesrv.routeinfo.BrokerHousekeepingService;
import org.apache.rocketmq.namesrv.routeinfo.RouteInfoManager;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.Configuration;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.srvutil.FileWatchService;

public class NamesrvController {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqNamesrv");
    private static final Logger WATER_MARK_LOG = LoggerFactory.getLogger((String)"RocketmqNamesrvWaterMark");
    private final NamesrvConfig namesrvConfig;
    private final NettyServerConfig nettyServerConfig;
    private final NettyClientConfig nettyClientConfig;
    private final ScheduledExecutorService scheduledExecutorService = ThreadUtils.newScheduledThreadPool((int)1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("NSScheduledThread").daemon(true).build());
    private final ScheduledExecutorService scanExecutorService = ThreadUtils.newScheduledThreadPool((int)1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("NSScanScheduledThread").daemon(true).build());
    private final KVConfigManager kvConfigManager;
    private final RouteInfoManager routeInfoManager;
    private RemotingClient remotingClient;
    private RemotingServer remotingServer;
    private final BrokerHousekeepingService brokerHousekeepingService;
    private ExecutorService defaultExecutor;
    private ExecutorService clientRequestExecutor;
    private BlockingQueue<Runnable> defaultThreadPoolQueue;
    private BlockingQueue<Runnable> clientRequestThreadPoolQueue;
    private final Configuration configuration;
    private FileWatchService fileWatchService;

    public NamesrvController(NamesrvConfig namesrvConfig, NettyServerConfig nettyServerConfig) {
        this(namesrvConfig, nettyServerConfig, new NettyClientConfig());
    }

    public NamesrvController(NamesrvConfig namesrvConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig) {
        this.namesrvConfig = namesrvConfig;
        this.nettyServerConfig = nettyServerConfig;
        this.nettyClientConfig = nettyClientConfig;
        this.kvConfigManager = new KVConfigManager(this);
        this.brokerHousekeepingService = new BrokerHousekeepingService(this);
        this.routeInfoManager = new RouteInfoManager(namesrvConfig, this);
        this.configuration = new Configuration(LOGGER, new Object[]{this.namesrvConfig, this.nettyServerConfig});
        this.configuration.setStorePathFromConfig((Object)this.namesrvConfig, "configStorePath");
    }

    public boolean initialize() {
        this.loadConfig();
        this.initiateNetworkComponents();
        this.initiateThreadExecutors();
        this.registerProcessor();
        this.startScheduleService();
        this.initiateSslContext();
        this.initiateRpcHooks();
        return true;
    }

    private void loadConfig() {
        this.kvConfigManager.load();
    }

    private void startScheduleService() {
        this.scanExecutorService.scheduleAtFixedRate(this.routeInfoManager::scanNotActiveBroker, 5L, this.namesrvConfig.getScanNotActiveBrokerInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(this.kvConfigManager::printAllPeriodically, 1L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.printWaterMark();
            }
            catch (Throwable e) {
                LOGGER.error("printWaterMark error.", e);
            }
        }, 10L, 1L, TimeUnit.SECONDS);
    }

    private void initiateNetworkComponents() {
        this.remotingServer = new NettyRemotingServer(this.nettyServerConfig, (ChannelEventListener)this.brokerHousekeepingService);
        this.remotingClient = new NettyRemotingClient(this.nettyClientConfig);
    }

    private void initiateThreadExecutors() {
        this.defaultThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.namesrvConfig.getDefaultThreadPoolQueueCapacity());
        this.defaultExecutor = ThreadUtils.newThreadPoolExecutor((int)this.namesrvConfig.getDefaultThreadPoolNums(), (int)this.namesrvConfig.getDefaultThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, this.defaultThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("RemotingExecutorThread_"));
        this.clientRequestThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.namesrvConfig.getClientRequestThreadPoolQueueCapacity());
        this.clientRequestExecutor = ThreadUtils.newThreadPoolExecutor((int)this.namesrvConfig.getClientRequestThreadPoolNums(), (int)this.namesrvConfig.getClientRequestThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, this.clientRequestThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ClientRequestExecutorThread_"));
    }

    private void initiateSslContext() {
        if (TlsSystemConfig.tlsMode == TlsMode.DISABLED) {
            return;
        }
        String[] watchFiles = new String[]{TlsSystemConfig.tlsServerCertPath, TlsSystemConfig.tlsServerKeyPath, TlsSystemConfig.tlsServerTrustCertPath};
        FileWatchService.Listener listener = new FileWatchService.Listener(){
            boolean certChanged;
            boolean keyChanged = false;

            public void onChanged(String path) {
                if (path.equals(TlsSystemConfig.tlsServerTrustCertPath)) {
                    LOGGER.info("The trust certificate changed, reload the ssl context");
                    ((NettyRemotingServer)NamesrvController.this.remotingServer).loadSslContext();
                }
                if (path.equals(TlsSystemConfig.tlsServerCertPath)) {
                    this.certChanged = true;
                }
                if (path.equals(TlsSystemConfig.tlsServerKeyPath)) {
                    this.keyChanged = true;
                }
                if (this.certChanged && this.keyChanged) {
                    LOGGER.info("The certificate and private key changed, reload the ssl context");
                    this.keyChanged = false;
                    this.certChanged = false;
                    ((NettyRemotingServer)NamesrvController.this.remotingServer).loadSslContext();
                }
            }
        };
        try {
            this.fileWatchService = new FileWatchService(watchFiles, listener);
        }
        catch (Exception e) {
            LOGGER.warn("FileWatchService created error, can't load the certificate dynamically");
        }
    }

    private void printWaterMark() {
        WATER_MARK_LOG.info("[WATERMARK] ClientQueueSize:{} ClientQueueSlowTime:{} DefaultQueueSize:{} DefaultQueueSlowTime:{}", new Object[]{this.clientRequestThreadPoolQueue.size(), this.headSlowTimeMills(this.clientRequestThreadPoolQueue), this.defaultThreadPoolQueue.size(), this.headSlowTimeMills(this.defaultThreadPoolQueue)});
    }

    private long headSlowTimeMills(BlockingQueue<Runnable> q) {
        Runnable inner;
        long slowTimeMills = 0L;
        Runnable firstRunnable = (Runnable)q.peek();
        if (firstRunnable instanceof FutureTaskExt && (inner = ((FutureTaskExt)firstRunnable).getRunnable()) instanceof RequestTask) {
            slowTimeMills = System.currentTimeMillis() - ((RequestTask)inner).getCreateTimestamp();
        }
        if (slowTimeMills < 0L) {
            slowTimeMills = 0L;
        }
        return slowTimeMills;
    }

    private void registerProcessor() {
        if (this.namesrvConfig.isClusterTest()) {
            this.remotingServer.registerDefaultProcessor((NettyRequestProcessor)new ClusterTestRequestProcessor(this, this.namesrvConfig.getProductEnvName()), this.defaultExecutor);
        } else {
            ClientRequestProcessor clientRequestProcessor = new ClientRequestProcessor(this);
            this.remotingServer.registerProcessor(105, (NettyRequestProcessor)clientRequestProcessor, this.clientRequestExecutor);
            this.remotingServer.registerDefaultProcessor((NettyRequestProcessor)new DefaultRequestProcessor(this), this.defaultExecutor);
        }
    }

    private void initiateRpcHooks() {
        this.remotingServer.registerRPCHook((RPCHook)new ZoneRouteRPCHook());
    }

    public void start() throws Exception {
        this.remotingServer.start();
        if (0 == this.nettyServerConfig.getListenPort()) {
            this.nettyServerConfig.setListenPort(this.remotingServer.localListenPort());
        }
        this.remotingClient.updateNameServerAddressList(Collections.singletonList(NetworkUtil.getLocalAddress() + ":" + this.nettyServerConfig.getListenPort()));
        this.remotingClient.start();
        if (this.fileWatchService != null) {
            this.fileWatchService.start();
        }
        this.routeInfoManager.start();
    }

    public void shutdown() {
        this.remotingClient.shutdown();
        this.remotingServer.shutdown();
        this.defaultExecutor.shutdown();
        this.clientRequestExecutor.shutdown();
        this.scheduledExecutorService.shutdown();
        this.scanExecutorService.shutdown();
        this.routeInfoManager.shutdown();
        if (this.fileWatchService != null) {
            this.fileWatchService.shutdown();
        }
    }

    public NamesrvConfig getNamesrvConfig() {
        return this.namesrvConfig;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    public KVConfigManager getKvConfigManager() {
        return this.kvConfigManager;
    }

    public RouteInfoManager getRouteInfoManager() {
        return this.routeInfoManager;
    }

    public RemotingServer getRemotingServer() {
        return this.remotingServer;
    }

    public RemotingClient getRemotingClient() {
        return this.remotingClient;
    }

    public void setRemotingServer(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

