/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.activity;

import io.netty.channel.ChannelHandlerContext;
import java.time.Duration;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.processor.validator.DefaultTopicMessageTypeValidator;
import org.apache.rocketmq.proxy.processor.validator.TopicMessageTypeValidator;
import org.apache.rocketmq.proxy.remoting.activity.AbstractRemotingActivity;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.RecallMessageRequestHeader;

public class RecallMessageActivity
extends AbstractRemotingActivity {
    TopicMessageTypeValidator topicMessageTypeValidator = new DefaultTopicMessageTypeValidator();

    public RecallMessageActivity(RequestPipeline requestPipeline, MessagingProcessor messagingProcessor) {
        super(requestPipeline, messagingProcessor);
    }

    @Override
    public RemotingCommand processRequest0(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        RecallMessageRequestHeader requestHeader = (RecallMessageRequestHeader)request.decodeCommandCustomHeader(RecallMessageRequestHeader.class);
        String topic = requestHeader.getTopic();
        if (ConfigurationManager.getProxyConfig().isEnableTopicMessageTypeCheck()) {
            TopicMessageType messageType = this.messagingProcessor.getMetadataService().getTopicMessageType(context, topic);
            this.topicMessageTypeValidator.validate(messageType, TopicMessageType.DELAY);
        }
        return this.request(ctx, request, context, Duration.ofSeconds(2L).toMillis());
    }
}

