/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.core;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.RaftServerService;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequestProcessor;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.util.concurrent.Executor;

public abstract class NodeRequestProcessor<T extends Message>
extends RpcRequestProcessor<T> {
    public NodeRequestProcessor(Executor executor, Message defaultResp) {
        super(executor, defaultResp);
    }

    protected abstract Message processRequest0(RaftServerService var1, T var2, RpcRequestClosure var3);

    protected abstract String getPeerId(T var1);

    protected abstract String getGroupId(T var1);

    @Override
    public Message processRequest(T request, RpcRequestClosure done) {
        PeerId peer = new PeerId();
        String peerIdStr = this.getPeerId(request);
        if (peer.parse(peerIdStr)) {
            String groupId = this.getGroupId(request);
            Node node = NodeManager.getInstance().get(groupId, peer);
            if (node != null) {
                return this.processRequest0((RaftServerService)((Object)node), request, done);
            }
            return RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), RaftError.ENOENT, "Peer id not found: %s, group: %s", peerIdStr, groupId);
        }
        return RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), RaftError.EINVAL, "Fail to parse peerId: %s", peerIdStr);
    }
}

