/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.internal;

import com.alipay.sofa.jraft.util.BufferUtils;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class UnsafeUtf8Util {
    public static final int MAX_BYTES_PER_CHAR = 3;

    public static String decodeUtf8(byte[] bytes, int index, int size) {
        byte b;
        int offset;
        if ((index | size | bytes.length - index - size) < 0) {
            throw new ArrayIndexOutOfBoundsException("buffer length=" + bytes.length + ", index=" + index + ", size=" + size);
        }
        int limit = offset + size;
        char[] resultArr = new char[size];
        int resultPos = 0;
        for (offset = index; offset < limit && DecodeUtil.isOneByte(b = UnsafeUtil.getByte(bytes, (long)offset)); ++offset) {
            DecodeUtil.handleOneByte(b, resultArr, resultPos++);
        }
        while (offset < limit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.getByte(bytes, (long)offset++))) {
                byte b2;
                DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                while (offset < limit && DecodeUtil.isOneByte(b2 = UnsafeUtil.getByte(bytes, (long)offset))) {
                    ++offset;
                    DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (offset >= limit) {
                    throw UnsafeUtf8Util.invalidUtf8();
                }
                DecodeUtil.handleTwoBytes(byte1, UnsafeUtil.getByte(bytes, (long)offset++), resultArr, resultPos++);
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (offset >= limit - 1) {
                    throw UnsafeUtf8Util.invalidUtf8();
                }
                DecodeUtil.handleThreeBytes(byte1, UnsafeUtil.getByte(bytes, (long)offset++), UnsafeUtil.getByte(bytes, (long)offset++), resultArr, resultPos++);
                continue;
            }
            if (offset >= limit - 2) {
                throw UnsafeUtf8Util.invalidUtf8();
            }
            DecodeUtil.handleFourBytes(byte1, UnsafeUtil.getByte(bytes, (long)offset++), UnsafeUtil.getByte(bytes, (long)offset++), UnsafeUtil.getByte(bytes, (long)offset++), resultArr, resultPos++);
            ++resultPos;
        }
        if (resultPos < resultArr.length) {
            resultArr = Arrays.copyOf(resultArr, resultPos);
        }
        return UnsafeUtil.moveToString(resultArr);
    }

    public static String decodeUtf8Direct(ByteBuffer buffer, int index, int size) {
        byte b;
        long address;
        if ((index | size | buffer.limit() - index - size) < 0) {
            throw new ArrayIndexOutOfBoundsException("buffer limit=" + buffer.limit() + ", index=" + index + ", limit=" + size);
        }
        long addressLimit = address + (long)size;
        char[] resultArr = new char[size];
        int resultPos = 0;
        for (address = UnsafeUtil.addressOffset(buffer) + (long)index; address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.getByte(address)); ++address) {
            DecodeUtil.handleOneByte(b, resultArr, resultPos++);
        }
        while (address < addressLimit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.getByte(address++))) {
                byte b2;
                DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                while (address < addressLimit && DecodeUtil.isOneByte(b2 = UnsafeUtil.getByte(address))) {
                    ++address;
                    DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (address >= addressLimit) {
                    throw UnsafeUtf8Util.invalidUtf8();
                }
                DecodeUtil.handleTwoBytes(byte1, UnsafeUtil.getByte(address++), resultArr, resultPos++);
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (address >= addressLimit - 1L) {
                    throw UnsafeUtf8Util.invalidUtf8();
                }
                DecodeUtil.handleThreeBytes(byte1, UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), resultArr, resultPos++);
                continue;
            }
            if (address >= addressLimit - 2L) {
                throw UnsafeUtf8Util.invalidUtf8();
            }
            DecodeUtil.handleFourBytes(byte1, UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), resultArr, resultPos++);
            ++resultPos;
        }
        if (resultPos < resultArr.length) {
            resultArr = Arrays.copyOf(resultArr, resultPos);
        }
        return UnsafeUtil.moveToString(resultArr);
    }

    public static int encodeUtf8(CharSequence in, byte[] out, int offset, int length) {
        char c;
        int inIx;
        long outIx = offset;
        long outLimit = outIx + (long)length;
        int inLimit = in.length();
        if (inLimit > length || out.length - length < offset) {
            throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + (offset + length));
        }
        for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
            UnsafeUtil.putByte(out, outIx++, (byte)c);
        }
        if (inIx == inLimit) {
            return (int)outIx;
        }
        while (inIx < inLimit) {
            c = in.charAt(inIx);
            if (c < '\u0080' && outIx < outLimit) {
                UnsafeUtil.putByte(out, outIx++, (byte)c);
            } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                UnsafeUtil.putByte(out, outIx++, (byte)(0x3C0 | c >>> 6));
                UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
            } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                UnsafeUtil.putByte(out, outIx++, (byte)(0x1E0 | c >>> 12));
                UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
            } else if (outIx <= outLimit - 4L) {
                char low;
                if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (inIx - 1) + " of " + inLimit);
                }
                int codePoint = Character.toCodePoint(c, low);
                UnsafeUtil.putByte(out, outIx++, (byte)(0xF0 | codePoint >>> 18));
                UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint));
            } else {
                if (!('\ud800' > c || c > '\udfff' || inIx + 1 != inLimit && Character.isSurrogatePair(c, in.charAt(inIx + 1)))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + inIx + " of " + inLimit);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + outIx);
            }
            ++inIx;
        }
        return (int)outIx;
    }

    public static void encodeUtf8Direct(CharSequence in, ByteBuffer out) {
        char c;
        int inIx;
        long address = UnsafeUtil.addressOffset(out);
        long outIx = address + (long)out.position();
        long outLimit = address + (long)out.limit();
        int inLimit = in.length();
        if ((long)inLimit > outLimit - outIx) {
            throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + out.limit());
        }
        for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
            UnsafeUtil.putByte(outIx++, (byte)c);
        }
        if (inIx == inLimit) {
            BufferUtils.position(out, (int)(outIx - address));
            return;
        }
        while (inIx < inLimit) {
            c = in.charAt(inIx);
            if (c < '\u0080' && outIx < outLimit) {
                UnsafeUtil.putByte(outIx++, (byte)c);
            } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                UnsafeUtil.putByte(outIx++, (byte)(0x3C0 | c >>> 6));
                UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
            } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                UnsafeUtil.putByte(outIx++, (byte)(0x1E0 | c >>> 12));
                UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
            } else if (outIx <= outLimit - 4L) {
                char low;
                if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (inIx - 1) + " of " + inLimit);
                }
                int codePoint = Character.toCodePoint(c, low);
                UnsafeUtil.putByte(outIx++, (byte)(0xF0 | codePoint >>> 18));
                UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint));
            } else {
                if (!('\ud800' > c || c > '\udfff' || inIx + 1 != inLimit && Character.isSurrogatePair(c, in.charAt(inIx + 1)))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + inIx + " of " + inLimit);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + outIx);
            }
            ++inIx;
        }
        BufferUtils.position(out, (int)(outIx - address));
    }

    public static int encodedLength(CharSequence sequence) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += UnsafeUtf8Util.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i + " of " + utf16Length);
            }
            ++i;
        }
        return utf8Length;
    }

    static IllegalStateException invalidUtf8() {
        return new IllegalStateException("Message had invalid UTF-8.");
    }

    private UnsafeUtf8Util() {
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte b) {
            return b >= 0;
        }

        private static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        private static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        private static void handleOneByte(byte byte1, char[] resultArr, int resultPos) {
            resultArr[resultPos] = (char)byte1;
        }

        private static void handleTwoBytes(byte byte1, byte byte2, char[] resultArr, int resultPos) {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                throw UnsafeUtf8Util.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        private static void handleThreeBytes(byte byte1, byte byte2, byte byte3, char[] resultArr, int resultPos) {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw UnsafeUtf8Util.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        private static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, char[] resultArr, int resultPos) {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw UnsafeUtf8Util.invalidUtf8();
            }
            int codePoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            resultArr[resultPos] = DecodeUtil.highSurrogate(codePoint);
            resultArr[resultPos + 1] = DecodeUtil.lowSurrogate(codePoint);
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }
}

