/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.core;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.core.MessageStoreFilter;

public class MessageStoreTopicFilter
implements MessageStoreFilter {
    private final Set<String> topicBlackSet = new HashSet<String>();

    public MessageStoreTopicFilter(MessageStoreConfig storeConfig) {
        this.topicBlackSet.add(storeConfig.getBrokerClusterName());
        this.topicBlackSet.add(storeConfig.getBrokerName());
    }

    @Override
    public boolean filterTopic(String topicName) {
        if (StringUtils.isBlank((CharSequence)topicName)) {
            return true;
        }
        return TopicValidator.isSystemTopic((String)topicName) || PopAckConstants.isStartWithRevivePrefix((String)topicName) || this.topicBlackSet.contains(topicName) || MixAll.isLmq((String)topicName);
    }

    @Override
    public void addTopicToBlackList(String topicName) {
        this.topicBlackSet.add(topicName);
    }
}

