/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis.consumer;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.rocketmq.client.apis.consumer.FilterExpressionType;

public class FilterExpression {
    private static final String TAG_EXPRESSION_SUB_ALL = "*";
    public static final FilterExpression SUB_ALL = new FilterExpression("*");
    private final String expression;
    private final FilterExpressionType filterExpressionType;

    public FilterExpression(String expression, FilterExpressionType filterExpressionType) {
        this.expression = (String)Preconditions.checkNotNull((Object)expression, (Object)"expression should not be null");
        this.filterExpressionType = (FilterExpressionType)((Object)Preconditions.checkNotNull((Object)((Object)filterExpressionType), (Object)"filterExpressionType should not be null"));
    }

    public FilterExpression(String expression) {
        this(expression, FilterExpressionType.TAG);
    }

    public FilterExpression() {
        this(TAG_EXPRESSION_SUB_ALL);
    }

    public String getExpression() {
        return this.expression;
    }

    public FilterExpressionType getFilterExpressionType() {
        return this.filterExpressionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterExpression that = (FilterExpression)o;
        return this.expression.equals(that.expression) && this.filterExpressionType == that.filterExpressionType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expression, this.filterExpressionType});
    }
}

