/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class TlsUtil {
    private TlsUtil() {
    }

    public static SSLSocketFactory sslSocketFactory(@Nullable KeyManager keyManager, TrustManager trustManager) throws SSLException {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLS");
            if (keyManager == null) {
                sslContext.init(null, new TrustManager[]{trustManager}, null);
            } else {
                sslContext.init(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, null);
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SSLException("Could not set trusted certificates for TLS connection, are they valid X.509 in PEM format?", e);
        }
        return sslContext.getSocketFactory();
    }

    public static X509KeyManager keyManager(byte[] privateKeyPem, byte[] certificatePem) throws SSLException {
        Objects.requireNonNull(privateKeyPem, "privateKeyPem");
        Objects.requireNonNull(certificatePem, "certificatePem");
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyPem);
            PrivateKey key = factory.generatePrivate(keySpec);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> chain = new ArrayList<Certificate>();
            ByteArrayInputStream is = new ByteArrayInputStream(certificatePem);
            while (is.available() > 0) {
                chain.add(cf.generateCertificate(is));
            }
            ks.setKeyEntry("trusted", key, "".toCharArray(), chain.toArray(new Certificate[0]));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, "".toCharArray());
            return (X509KeyManager)kmf.getKeyManagers()[0];
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new SSLException("Could not build KeyManagerFactory from clientKeysPem.", e);
        }
    }

    public static X509TrustManager trustManager(byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ByteArrayInputStream is = new ByteArrayInputStream(trustedCertificatesPem);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            int i = 0;
            while (is.available() > 0) {
                X509Certificate cert = (X509Certificate)factory.generateCertificate(is);
                ks.setCertificateEntry("cert_" + i, cert);
                ++i;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            return (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SSLException("Could not build TrustManagerFactory from trustedCertificatesPem.", e);
        }
    }
}

