/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Status;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.javacrumbs.futureconverter.java8guava.FutureConverter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.java.exception.StatusChecker;
import org.apache.rocketmq.client.java.impl.Settings;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.SimpleSubscriptionSettings;
import org.apache.rocketmq.client.java.impl.consumer.SubscriptionLoadBalancer;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.message.protocol.Resource;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.route.TopicRouteData;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleConsumerImpl
extends ConsumerImpl
implements SimpleConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleConsumerImpl.class);
    private final SimpleSubscriptionSettings simpleSubscriptionSettings;
    private final String consumerGroup;
    private final Duration awaitDuration;
    private final AtomicInteger topicIndex;
    private final Map<String, FilterExpression> subscriptionExpressions;
    private final ConcurrentMap<String, SubscriptionLoadBalancer> subTopicRouteDataResultCache;

    public SimpleConsumerImpl(ClientConfiguration clientConfiguration, String consumerGroup, Duration awaitDuration, Map<String, FilterExpression> subscriptionExpressions) {
        super(clientConfiguration, consumerGroup, subscriptionExpressions.keySet());
        Resource groupResource = new Resource(consumerGroup);
        this.simpleSubscriptionSettings = new SimpleSubscriptionSettings(this.clientId, this.endpoints, groupResource, clientConfiguration.getRequestTimeout(), awaitDuration, subscriptionExpressions);
        this.consumerGroup = consumerGroup;
        this.awaitDuration = awaitDuration;
        this.topicIndex = new AtomicInteger(RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE));
        this.subscriptionExpressions = subscriptionExpressions;
        this.subTopicRouteDataResultCache = new ConcurrentHashMap<String, SubscriptionLoadBalancer>();
    }

    @Override
    protected void startUp() throws Exception {
        try {
            LOGGER.info("Begin to start the rocketmq simple consumer, clientId={}", (Object)this.clientId);
            super.startUp();
            LOGGER.info("The rocketmq simple consumer starts successfully, clientId={}", (Object)this.clientId);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to start the rocketmq simple consumer, try to shutdown it, clientId={}", (Object)this.clientId, (Object)t);
            this.shutDown();
            throw t;
        }
    }

    @Override
    protected void shutDown() throws InterruptedException {
        LOGGER.info("Begin to shutdown the rocketmq simple consumer, clientId={}", (Object)this.clientId);
        super.shutDown();
        LOGGER.info("Shutdown the rocketmq simple consumer successfully, clientId={}", (Object)this.clientId);
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public SimpleConsumer subscribe(String topic, FilterExpression filterExpression) throws ClientException {
        if (!this.isRunning()) {
            LOGGER.error("Unable to add subscription because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("Simple consumer is not running now");
        }
        ListenableFuture<TopicRouteData> future = this.getRouteData(topic);
        this.handleClientFuture(future);
        this.subscriptionExpressions.put(topic, filterExpression);
        return this;
    }

    public SimpleConsumer unsubscribe(String topic) {
        if (!this.isRunning()) {
            LOGGER.error("Unable to remove subscription because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("Simple consumer is not running now");
        }
        this.subscriptionExpressions.remove(topic);
        return this;
    }

    public Map<String, FilterExpression> getSubscriptionExpressions() {
        return new HashMap<String, FilterExpression>(this.subscriptionExpressions);
    }

    public List<MessageView> receive(int maxMessageNum, Duration invisibleDuration) throws ClientException {
        ListenableFuture<List<MessageView>> future = this.receive0(maxMessageNum, invisibleDuration);
        return this.handleClientFuture(future);
    }

    public CompletableFuture<List<MessageView>> receiveAsync(int maxMessageNum, Duration invisibleDuration) {
        ListenableFuture<List<MessageView>> future = this.receive0(maxMessageNum, invisibleDuration);
        return FutureConverter.toCompletableFuture(future);
    }

    public ListenableFuture<List<MessageView>> receive0(int maxMessageNum, Duration invisibleDuration) {
        if (!this.isRunning()) {
            LOGGER.error("Unable to receive message because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            IllegalStateException e = new IllegalStateException("Simple consumer is not running now");
            return Futures.immediateFailedFuture((Throwable)e);
        }
        if (maxMessageNum <= 0) {
            IllegalArgumentException e = new IllegalArgumentException("maxMessageNum must be greater than 0");
            return Futures.immediateFailedFuture((Throwable)e);
        }
        HashMap<String, FilterExpression> copy = new HashMap<String, FilterExpression>(this.subscriptionExpressions);
        ArrayList<String> topics = new ArrayList<String>(copy.keySet());
        if (topics.isEmpty()) {
            IllegalArgumentException e = new IllegalArgumentException("There is no topic to receive message");
            return Futures.immediateFailedFuture((Throwable)e);
        }
        String topic = topics.get(IntMath.mod((int)this.topicIndex.getAndIncrement(), (int)topics.size()));
        FilterExpression filterExpression = copy.get(topic);
        ListenableFuture<SubscriptionLoadBalancer> routeFuture = this.getSubscriptionTopicRouteResult(topic);
        ListenableFuture future0 = Futures.transformAsync(routeFuture, result -> {
            MessageQueueImpl mq = result.takeMessageQueue();
            ReceiveMessageRequest request = this.wrapReceiveMessageRequest(maxMessageNum, mq, filterExpression, invisibleDuration);
            return this.receiveMessage(request, mq, this.awaitDuration);
        }, (Executor)MoreExecutors.directExecutor());
        return Futures.transformAsync((ListenableFuture)future0, result -> Futures.immediateFuture(result.getMessageViews()), (Executor)this.clientCallbackExecutor);
    }

    public void ack(MessageView messageView) throws ClientException {
        ListenableFuture<Void> future = this.ack0(messageView);
        this.handleClientFuture(future);
    }

    public CompletableFuture<Void> ackAsync(MessageView messageView) {
        ListenableFuture<Void> future = this.ack0(messageView);
        return FutureConverter.toCompletableFuture(future);
    }

    private ListenableFuture<Void> ack0(MessageView messageView) {
        if (!this.isRunning()) {
            LOGGER.error("Unable to ack message because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            IllegalStateException e = new IllegalStateException("Simple consumer is not running now");
            return Futures.immediateFailedFuture((Throwable)e);
        }
        if (!(messageView instanceof MessageViewImpl)) {
            IllegalArgumentException exception = new IllegalArgumentException("Failed downcasting for messageView");
            return Futures.immediateFailedFuture((Throwable)exception);
        }
        MessageViewImpl impl = (MessageViewImpl)messageView;
        RpcFuture<AckMessageRequest, AckMessageResponse> future = this.ackMessage(impl);
        return Futures.transformAsync(future, response -> {
            Status status = response.getStatus();
            StatusChecker.check(status, future);
            return Futures.immediateVoidFuture();
        }, (Executor)this.clientCallbackExecutor);
    }

    public void changeInvisibleDuration(MessageView messageView, Duration invisibleDuration) throws ClientException {
        ListenableFuture<Void> future = this.changeInvisibleDuration0(messageView, invisibleDuration);
        this.handleClientFuture(future);
    }

    public CompletableFuture<Void> changeInvisibleDurationAsync(MessageView messageView, Duration invisibleDuration) {
        ListenableFuture<Void> future = this.changeInvisibleDuration0(messageView, invisibleDuration);
        return FutureConverter.toCompletableFuture(future);
    }

    public ListenableFuture<Void> changeInvisibleDuration0(MessageView messageView, Duration invisibleDuration) {
        if (!this.isRunning()) {
            LOGGER.error("Unable to change invisible duration because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            IllegalStateException e = new IllegalStateException("Simple consumer is not running now");
            return Futures.immediateFailedFuture((Throwable)e);
        }
        if (!(messageView instanceof MessageViewImpl)) {
            IllegalArgumentException exception = new IllegalArgumentException("Failed downcasting for messageView");
            return Futures.immediateFailedFuture((Throwable)exception);
        }
        MessageViewImpl impl = (MessageViewImpl)messageView;
        RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> future = this.changeInvisibleDuration(impl, invisibleDuration);
        return Futures.transformAsync(future, response -> {
            impl.setReceiptHandle(response.getReceiptHandle());
            Status status = response.getStatus();
            StatusChecker.check(status, future);
            return Futures.immediateVoidFuture();
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void close() {
        this.stopAsync().awaitTerminated();
    }

    @Override
    public Settings getSettings() {
        return this.simpleSubscriptionSettings;
    }

    @Override
    public void onTopicRouteDataUpdate0(String topic, TopicRouteData topicRouteData) {
        SubscriptionLoadBalancer subscriptionLoadBalancer = new SubscriptionLoadBalancer(topicRouteData);
        this.subTopicRouteDataResultCache.put(topic, subscriptionLoadBalancer);
    }

    private ListenableFuture<SubscriptionLoadBalancer> getSubscriptionTopicRouteResult(String topic) {
        SettableFuture future0 = SettableFuture.create();
        SubscriptionLoadBalancer result = (SubscriptionLoadBalancer)this.subTopicRouteDataResultCache.get(topic);
        if (null != result) {
            future0.set((Object)result);
            return future0;
        }
        ListenableFuture<TopicRouteData> future = this.getRouteData(topic);
        return Futures.transform(future, topicRouteDataResult -> {
            SubscriptionLoadBalancer subscriptionLoadBalancer = new SubscriptionLoadBalancer((TopicRouteData)topicRouteDataResult);
            this.subTopicRouteDataResultCache.put(topic, subscriptionLoadBalancer);
            return subscriptionLoadBalancer;
        }, (Executor)MoreExecutors.directExecutor());
    }
}

